/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addon.cloudevents.quarkus;

import io.smallrye.reactive.messaging.ChannelRegistar;
import io.smallrye.reactive.messaging.ChannelRegistry;
import io.smallrye.reactive.messaging.extension.EmitterConfiguration;
import io.smallrye.reactive.messaging.extension.MediatorManager;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.eclipse.microprofile.reactive.messaging.Emitter;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.kie.kogito.addon.cloudevents.quarkus.ChannelResolver;
import org.kie.kogito.addon.cloudevents.quarkus.decorators.MessageDecorator;
import org.kie.kogito.addon.cloudevents.quarkus.decorators.MessageDecoratorFactory;
import org.kie.kogito.conf.ConfigBean;
import org.kie.kogito.event.EventEmitter;
import org.kie.kogito.event.EventMarshaller;
import org.kie.kogito.services.event.impl.DefaultEventMarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class QuarkusMultiCloudEventEmitter
implements EventEmitter,
ChannelRegistar {
    private static Logger logger = LoggerFactory.getLogger(QuarkusMultiCloudEventEmitter.class);
    private MessageDecorator messageDecorator;
    @Inject
    private ChannelRegistry channelRegistry;
    @Inject
    private MediatorManager mediatorManager;
    @Inject
    private ConfigBean configBean;
    @Inject
    private ChannelResolver channelResolver;
    @Inject
    private Instance<EventMarshaller> marshallerInstance;
    private EventMarshaller marshaller;

    @PostConstruct
    private void init() {
        this.marshaller = this.marshallerInstance.isResolvable() ? (EventMarshaller)this.marshallerInstance.get() : new DefaultEventMarshaller();
        this.messageDecorator = MessageDecoratorFactory.newInstance((boolean)this.configBean.useCloudEvents());
    }

    private EmitterConfiguration emitterConf(String name) {
        return new EmitterConfiguration(name, false, null, null);
    }

    public <T> CompletionStage<Void> emit(T e, String type, Optional<Function<T, Object>> processDecorator) {
        Message message = this.messageDecorator.decorate((Object)this.marshaller.marshall(this.configBean.useCloudEvents() ? processDecorator.map(d -> d.apply(e)).orElse(e) : e));
        Emitter emitter = this.channelRegistry.getEmitter(type);
        if (emitter != null) {
            emitter.send(message);
        } else {
            logger.warn("Cannot found channel {}. Please add it to application.properties", (Object)type);
        }
        return (CompletionStage)message.getAck().get();
    }

    public void initialize() {
        this.channelResolver.getOuputChannels().stream().map(this::emitterConf).forEach(arg_0 -> ((MediatorManager)this.mediatorManager).addEmitter(arg_0));
    }
}

