/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.addons.common.deployment;

import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildStep;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.kie.kogito.quarkus.addons.common.deployment.KogitoCapability;

public abstract class RequireCapabilityKogitoAddOnProcessor {
    private final List<KogitoCapability> requiredCapabilities;

    public RequireCapabilityKogitoAddOnProcessor(KogitoCapability ... requiredCapabilities) {
        if (requiredCapabilities == null || requiredCapabilities.length == 0) {
            throw new IllegalArgumentException("Please set at least one capability");
        }
        this.requiredCapabilities = Arrays.asList(requiredCapabilities);
    }

    @BuildStep
    void verifyCapabilities(Capabilities capabilities) {
        List<KogitoCapability> missing = this.requiredCapabilities.stream().filter(kc -> capabilities.isMissing(kc.getCapability())).collect(Collectors.toList());
        if (!missing.isEmpty()) {
            throw this.exceptionForRequiredCapabilities(missing);
        }
    }

    private IllegalStateException exceptionForRequiredCapabilities(List<KogitoCapability> missingCapabilities) {
        StringBuilder sb = new StringBuilder();
        sb.append("The following capabilities are missing: \n");
        missingCapabilities.forEach(c -> {
            sb.append("\t - ").append(c.getCapability()).append("\n");
            sb.append("\t\t offered by the artifact ").append("org.kie.kogito").append(":").append(c.getOfferedBy()).append("\n");
        });
        sb.append("Add the above artifacts in your project's pom.xml file");
        return new IllegalStateException(sb.toString());
    }
}

