/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addon.quarkus.common.reactive.messaging;

import java.util.Collection;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.kie.kogito.addon.quarkus.common.reactive.messaging.MessageDecorator;

@ApplicationScoped
public class MessageDecoratorProvider {
    @Inject
    Instance<MessageDecorator> messageDecorators;
    private Collection<MessageDecorator> sortedMessageDecorators;

    @PostConstruct
    void init() {
        this.sortedMessageDecorators = this.messageDecorators.stream().sorted().collect(Collectors.toList());
    }

    public <T> Message<T> decorate(Message<T> message) {
        for (MessageDecorator messageDecorator : this.sortedMessageDecorators) {
            message = messageDecorator.decorate(message);
        }
        return message;
    }
}

