/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.addon;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.kogito.event.DataEvent;
import org.kie.kogito.event.EventPublisher;
import org.kie.kogito.event.process.ProcessInstanceDataEvent;
import org.kie.kogito.event.process.UserTaskInstanceDataEvent;
import org.kie.kogito.index.event.ProcessInstanceEventMapper;
import org.kie.kogito.index.event.UserTaskInstanceEventMapper;
import org.kie.kogito.index.json.JsonUtils;
import org.kie.kogito.index.model.Job;
import org.kie.kogito.index.service.IndexingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class DataIndexEventPublisher
implements EventPublisher {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataIndexEventPublisher.class);
    @Inject
    IndexingService indexingService;

    public void publish(DataEvent<?> event) {
        LOGGER.debug("Sending event to embedded data index: {}", event);
        switch (event.getType()) {
            case "ProcessInstanceEvent": {
                this.indexingService.indexProcessInstance(new ProcessInstanceEventMapper().apply((ProcessInstanceDataEvent)event));
                break;
            }
            case "UserTaskInstanceEvent": {
                this.indexingService.indexUserTaskInstance(new UserTaskInstanceEventMapper().apply((UserTaskInstanceDataEvent)event));
                break;
            }
            case "JobEvent": {
                try {
                    this.indexingService.indexJob((Job)JsonUtils.getObjectMapper().readValue(new String((byte[])event.getData()), Job.class));
                    break;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            default: {
                LOGGER.debug("Unknown type of event '{}', ignoring for this publisher", (Object)event.getType());
            }
        }
    }

    public void publish(Collection<DataEvent<?>> events) {
        events.forEach(this::publish);
    }

    protected void setIndexingService(IndexingService indexingService) {
        this.indexingService = indexingService;
    }
}

