/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.addon.api;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.eclipse.microprofile.context.ManagedExecutor;
import org.jbpm.workflow.core.Node;
import org.kie.kogito.addon.source.files.SourceFilesProvider;
import org.kie.kogito.index.api.KogitoRuntimeClient;
import org.kie.kogito.index.model.Job;
import org.kie.kogito.index.model.ProcessInstance;
import org.kie.kogito.index.model.UserTaskInstance;
import org.kie.kogito.index.service.DataIndexServiceException;
import org.kie.kogito.internal.process.runtime.KogitoWorkflowProcess;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.Processes;
import org.kie.kogito.process.impl.AbstractProcess;
import org.kie.kogito.svg.ProcessSvgService;

@ApplicationScoped
public class KogitoAddonRuntimeClientImpl
implements KogitoRuntimeClient {
    private ProcessSvgService processSvgService;
    private SourceFilesProvider sourceFilesProvider;
    private Processes processes;
    @Inject
    ManagedExecutor managedExecutor;

    @Inject
    public KogitoAddonRuntimeClientImpl(Instance<ProcessSvgService> processSvgService, SourceFilesProvider sourceFilesProvider, Instance<Processes> processesInstance) {
        this.processSvgService = processSvgService.isResolvable() ? (ProcessSvgService)processSvgService.get() : null;
        this.sourceFilesProvider = sourceFilesProvider;
        this.processes = processesInstance.isResolvable() ? (Processes)processesInstance.get() : null;
    }

    static <T> CompletableFuture<T> throwUnsupportedException() {
        return CompletableFuture.failedFuture(new UnsupportedOperationException());
    }

    public CompletableFuture<String> abortProcessInstance(String serviceURL, ProcessInstance processInstance) {
        return KogitoAddonRuntimeClientImpl.throwUnsupportedException();
    }

    public CompletableFuture<String> retryProcessInstance(String serviceURL, ProcessInstance processInstance) {
        return KogitoAddonRuntimeClientImpl.throwUnsupportedException();
    }

    public CompletableFuture<String> skipProcessInstance(String serviceURL, ProcessInstance processInstance) {
        return KogitoAddonRuntimeClientImpl.throwUnsupportedException();
    }

    public CompletableFuture<String> updateProcessInstanceVariables(String serviceURL, ProcessInstance processInstance, String variables) {
        return KogitoAddonRuntimeClientImpl.throwUnsupportedException();
    }

    public CompletableFuture<String> getProcessInstanceDiagram(String serviceURL, ProcessInstance processInstance) {
        if (this.processSvgService == null) {
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.supplyAsync(() -> this.processSvgService.getProcessInstanceSvg(processInstance.getProcessId(), processInstance.getId(), null).orElse(null), (Executor)this.managedExecutor);
    }

    public CompletableFuture<String> getProcessDefinitionSourceFileContent(String serviceURL, String processId) {
        return CompletableFuture.supplyAsync(() -> this.sourceFilesProvider.getProcessSourceFile(processId).map(sourceFile -> {
            try {
                return sourceFile.readContents();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }).map(String::new).orElseThrow(() -> new DataIndexServiceException("Source file not found for the specified process ID: " + processId)), (Executor)this.managedExecutor);
    }

    public CompletableFuture<List<org.kie.kogito.index.model.Node>> getProcessDefinitionNodes(String serviceURL, String processId) {
        Process process;
        Process process2 = process = this.processes != null ? this.processes.processById(processId) : null;
        if (process == null) {
            return CompletableFuture.completedFuture(null);
        }
        List nodes = ((KogitoWorkflowProcess)((AbstractProcess)process).get()).getNodesRecursively();
        List list = nodes.stream().map(n -> {
            org.kie.kogito.index.model.Node data = new org.kie.kogito.index.model.Node();
            data.setId(String.valueOf(n.getId()));
            data.setNodeId(((Node)n).getUniqueId());
            data.setMetadata(n.getMetaData());
            data.setType(n.getClass().getSimpleName());
            data.setName(n.getName());
            return data;
        }).collect(Collectors.toList());
        return CompletableFuture.completedFuture(list);
    }

    public CompletableFuture<String> triggerNodeInstance(String serviceURL, ProcessInstance processInstance, String nodeDefinitionId) {
        return KogitoAddonRuntimeClientImpl.throwUnsupportedException();
    }

    public CompletableFuture<String> retriggerNodeInstance(String serviceURL, ProcessInstance processInstance, String nodeInstanceId) {
        return KogitoAddonRuntimeClientImpl.throwUnsupportedException();
    }

    public CompletableFuture<String> cancelNodeInstance(String serviceURL, ProcessInstance processInstance, String nodeInstanceId) {
        return KogitoAddonRuntimeClientImpl.throwUnsupportedException();
    }

    public CompletableFuture<String> cancelJob(String serviceURL, Job job) {
        return KogitoAddonRuntimeClientImpl.throwUnsupportedException();
    }

    public CompletableFuture<String> rescheduleJob(String serviceURL, Job job, String newJobData) {
        return KogitoAddonRuntimeClientImpl.throwUnsupportedException();
    }

    public CompletableFuture<String> getUserTaskSchema(String serviceURL, UserTaskInstance userTaskInstance, String user, List<String> groups) {
        return KogitoAddonRuntimeClientImpl.throwUnsupportedException();
    }

    public CompletableFuture<String> updateUserTaskInstance(String serviceURL, UserTaskInstance userTaskInstance, String user, List<String> groups, Map taskInfo) {
        return KogitoAddonRuntimeClientImpl.throwUnsupportedException();
    }

    public CompletableFuture<String> createUserTaskInstanceComment(String serviceURL, UserTaskInstance userTaskInstance, String user, List<String> groups, String commentInfo) {
        return KogitoAddonRuntimeClientImpl.throwUnsupportedException();
    }

    public CompletableFuture<String> createUserTaskInstanceAttachment(String serviceURL, UserTaskInstance userTaskInstance, String user, List<String> groups, String name, String uri) {
        return KogitoAddonRuntimeClientImpl.throwUnsupportedException();
    }

    public CompletableFuture<String> updateUserTaskInstanceComment(String serviceURL, UserTaskInstance userTaskInstance, String user, List<String> groups, String commentId, String commentInfo) {
        return KogitoAddonRuntimeClientImpl.throwUnsupportedException();
    }

    public CompletableFuture<String> deleteUserTaskInstanceComment(String serviceURL, UserTaskInstance userTaskInstance, String user, List<String> groups, String commentId) {
        return KogitoAddonRuntimeClientImpl.throwUnsupportedException();
    }

    public CompletableFuture<String> updateUserTaskInstanceAttachment(String serviceURL, UserTaskInstance userTaskInstance, String user, List<String> groups, String attachmentId, String name, String uri) {
        return KogitoAddonRuntimeClientImpl.throwUnsupportedException();
    }

    public CompletableFuture<String> deleteUserTaskInstanceAttachment(String serviceURL, UserTaskInstance userTaskInstance, String user, List<String> groups, String attachmentId) {
        return KogitoAddonRuntimeClientImpl.throwUnsupportedException();
    }
}

