/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.events.process;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.smallrye.reactive.messaging.providers.locals.ContextAwareMessage;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.annotation.PostConstruct;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.reactive.messaging.Channel;
import org.eclipse.microprofile.reactive.messaging.Emitter;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.kie.kogito.addon.quarkus.common.reactive.messaging.MessageDecoratorProvider;
import org.kie.kogito.event.DataEvent;
import org.kie.kogito.event.EventPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ReactiveMessagingEventPublisher
implements EventPublisher {
    private static final String PI_TOPIC_NAME = "kogito-processinstances-events";
    private static final String UI_TOPIC_NAME = "kogito-usertaskinstances-events";
    private static final String VI_TOPIC_NAME = "kogito-variables-events";
    private static final Logger logger = LoggerFactory.getLogger(ReactiveMessagingEventPublisher.class);
    @Inject
    ObjectMapper json;
    @Inject
    @Channel(value="kogito-processinstances-events")
    Emitter<String> processInstancesEventsEmitter;
    @Inject
    @Channel(value="kogito-usertaskinstances-events")
    Emitter<String> userTasksEventsEmitter;
    @Inject
    @Channel(value="kogito-variables-events")
    Emitter<String> variablesEventsEmitter;
    @Inject
    @ConfigProperty(name="kogito.events.processinstances.enabled")
    Optional<Boolean> processInstancesEvents;
    @Inject
    @ConfigProperty(name="kogito.events.usertasks.enabled")
    Optional<Boolean> userTasksEvents;
    @Inject
    @ConfigProperty(name="kogito.events.variables.enabled")
    Optional<Boolean> variablesEvents;
    @Inject
    Instance<MessageDecoratorProvider> decoratorProviderInstance;
    private MessageDecoratorProvider decoratorProvider;

    @PostConstruct
    public void init() {
        this.decoratorProvider = this.decoratorProviderInstance.isResolvable() ? (MessageDecoratorProvider)this.decoratorProviderInstance.get() : null;
    }

    public void publish(DataEvent<?> event) {
        switch (event.getType()) {
            case "ProcessInstanceEvent": {
                if (!this.processInstancesEvents.orElse(true).booleanValue()) break;
                this.publishToTopic(event, this.processInstancesEventsEmitter, PI_TOPIC_NAME);
                break;
            }
            case "UserTaskInstanceEvent": {
                if (!this.userTasksEvents.orElse(true).booleanValue()) break;
                this.publishToTopic(event, this.userTasksEventsEmitter, UI_TOPIC_NAME);
                break;
            }
            case "VariableInstanceEvent": {
                if (!this.variablesEvents.orElse(true).booleanValue()) break;
                this.publishToTopic(event, this.variablesEventsEmitter, VI_TOPIC_NAME);
                break;
            }
            default: {
                logger.debug("Unknown type of event '{}', ignoring for this publisher", (Object)event.getType());
            }
        }
    }

    public void publish(Collection<DataEvent<?>> events) {
        for (DataEvent<?> event : events) {
            this.publish(event);
        }
    }

    protected void publishToTopic(DataEvent<?> event, Emitter<String> emitter, String topic) {
        if (emitter.hasRequests()) {
            logger.debug("Emitter {} is not ready to send messages", (Object)topic);
        }
        logger.debug("About to publish event {} to topic {}", event, (Object)topic);
        try {
            String eventString = this.json.writeValueAsString(event);
            logger.debug("Event payload '{}'", (Object)eventString);
            emitter.send(this.decorateMessage((Message<String>)ContextAwareMessage.of((Object)eventString).withAck(() -> this.onAck(event, topic)).withNack(reason -> this.onNack((Throwable)reason, event, topic))));
        }
        catch (Exception e) {
            logger.error("Error while creating event to topic {} for event {}", new Object[]{topic, event, e});
        }
    }

    protected CompletionStage<Void> onAck(DataEvent<?> event, String topic) {
        logger.debug("Successfully published event {} to topic {}", event, (Object)topic);
        return CompletableFuture.completedFuture(null);
    }

    protected CompletionStage<Void> onNack(Throwable reason, DataEvent<?> event, String topic) {
        logger.error("Error while publishing event to topic {} for event {}", new Object[]{topic, event, reason});
        return CompletableFuture.completedFuture(null);
    }

    protected Message<String> decorateMessage(Message<String> message) {
        return this.decoratorProvider != null ? this.decoratorProvider.decorate(message) : message;
    }
}

