/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.fabric8.k8s.service.catalog;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.kie.kogito.addons.k8s.resource.catalog.KubernetesServiceCatalog;
import org.kie.kogito.addons.k8s.resource.catalog.KubernetesServiceCatalogKey;
import org.kie.kogito.addons.quarkus.fabric8.k8s.service.catalog.GVK;
import org.kie.kogito.addons.quarkus.fabric8.k8s.service.catalog.KnativeServiceDiscovery;
import org.kie.kogito.addons.quarkus.fabric8.k8s.service.catalog.KnativeServiceUri;
import org.kie.kogito.addons.quarkus.fabric8.k8s.service.catalog.KubernetesResourceDiscovery;
import org.kie.kogito.addons.quarkus.fabric8.k8s.service.catalog.KubernetesResourceUri;
import org.kie.kogito.addons.quarkus.fabric8.k8s.service.catalog.OpenShiftResourceDiscovery;

@ApplicationScoped
final class Fabric8KubernetesServiceCatalog
implements KubernetesServiceCatalog {
    private final Map<KubernetesServiceCatalogKey, URI> services = new ConcurrentHashMap<KubernetesServiceCatalogKey, URI>();
    private final KnativeServiceDiscovery knativeServiceDiscovery;
    private final KubernetesResourceDiscovery kubernetesResourceDiscovery;
    private final OpenShiftResourceDiscovery openShiftResourceDiscovery;

    @Inject
    Fabric8KubernetesServiceCatalog(KnativeServiceDiscovery knativeServiceDiscovery, KubernetesResourceDiscovery kubernetesResourceDiscovery, OpenShiftResourceDiscovery openShiftResourceDiscovery) {
        this.knativeServiceDiscovery = knativeServiceDiscovery;
        this.kubernetesResourceDiscovery = kubernetesResourceDiscovery;
        this.openShiftResourceDiscovery = openShiftResourceDiscovery;
    }

    public Optional<URI> getServiceAddress(KubernetesServiceCatalogKey key) {
        Function<String, Optional> function;
        switch (key.getProtocol()) {
            case KNATIVE: {
                String[] splitCoordinates = key.getCoordinates().split("/");
                if (splitCoordinates.length == 1) {
                    function = coordinates -> this.knativeServiceDiscovery.query(new KnativeServiceUri(null, (String)coordinates));
                    break;
                }
                if (GVK.isValid(splitCoordinates[0])) {
                    function = coordinates -> this.kubernetesResourceDiscovery.query(KubernetesResourceUri.parse(coordinates));
                    break;
                }
                function = coordinates -> this.knativeServiceDiscovery.query(new KnativeServiceUri(splitCoordinates[0], splitCoordinates[1]));
                break;
            }
            case OPENSHIFT: {
                function = coordinates -> this.openShiftResourceDiscovery.query(KubernetesResourceUri.parse(coordinates));
                break;
            }
            case KUBERNETES: {
                function = coordinates -> this.kubernetesResourceDiscovery.query(KubernetesResourceUri.parse(coordinates));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported protocol: " + key.getProtocol());
            }
        }
        return Optional.ofNullable(this.services.computeIfAbsent(key, k -> ((Optional)function.apply(k.getCoordinates())).orElse(null)));
    }
}

