/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.fabric8.k8s.service.catalog;

import io.fabric8.knative.client.KnativeClient;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.OpenShiftConfig;
import org.kie.kogito.addons.k8s.resource.catalog.KubernetesServiceCatalog;
import org.kie.kogito.addons.k8s.resource.catalog.KubernetesServiceCatalogProvider;
import org.kie.kogito.addons.quarkus.fabric8.k8s.service.catalog.Fabric8KubernetesServiceCatalog;
import org.kie.kogito.addons.quarkus.fabric8.k8s.service.catalog.KnativeServiceDiscovery;
import org.kie.kogito.addons.quarkus.fabric8.k8s.service.catalog.KubernetesResourceDiscovery;
import org.kie.kogito.addons.quarkus.fabric8.k8s.service.catalog.OpenShiftResourceDiscovery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fabric8KubernetesServiceCatalogProvider
implements KubernetesServiceCatalogProvider {
    private static final Logger logger = LoggerFactory.getLogger(Fabric8KubernetesServiceCatalogProvider.class);

    public KubernetesServiceCatalog create() {
        logger.debug("Configuring k8s client...");
        OpenShiftConfig config = OpenShiftConfig.wrap((Config)new ConfigBuilder().build());
        config.setDisableApiGroupCheck(true);
        DefaultKubernetesClient kubernetesClient = new DefaultKubernetesClient((Config)config);
        KnativeServiceDiscovery knativeServiceDiscovery = new KnativeServiceDiscovery((KnativeClient)kubernetesClient.adapt(KnativeClient.class));
        KubernetesResourceDiscovery kubernetesResourceDiscovery = new KubernetesResourceDiscovery((KubernetesClient)kubernetesClient, knativeServiceDiscovery);
        OpenShiftResourceDiscovery openShiftResourceDiscovery = new OpenShiftResourceDiscovery((OpenShiftClient)kubernetesClient.adapt(OpenShiftClient.class), kubernetesResourceDiscovery);
        return new Fabric8KubernetesServiceCatalog(knativeServiceDiscovery, kubernetesResourceDiscovery, openShiftResourceDiscovery);
    }
}

