/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.fabric8.k8s.service.catalog;

import io.fabric8.knative.client.KnativeClient;
import io.fabric8.knative.serving.v1.Service;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.net.URI;
import java.util.Optional;
import org.kie.kogito.addons.quarkus.fabric8.k8s.service.catalog.AbstractResourceDiscovery;
import org.kie.kogito.addons.quarkus.fabric8.k8s.service.catalog.KnativeServiceUri;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
class KnativeServiceDiscovery
extends AbstractResourceDiscovery {
    private static final Logger logger = LoggerFactory.getLogger(KnativeServiceDiscovery.class);
    private final KnativeClient knativeClient;

    @Inject
    KnativeServiceDiscovery(KnativeClient knativeClient) {
        this.knativeClient = knativeClient;
    }

    Optional<URI> query(KnativeServiceUri knativeServiceUri) {
        String namespace;
        this.logConnection(this.knativeClient, knativeServiceUri.getResourceName());
        if (knativeServiceUri.getNamespace() == null) {
            namespace = this.knativeClient.getNamespace();
            this.logDefaultNamespace(namespace);
        } else {
            namespace = knativeServiceUri.getNamespace();
        }
        Service service = (Service)((Resource)((NonNamespaceOperation)this.knativeClient.services().inNamespace(namespace)).withName(knativeServiceUri.getResourceName())).get();
        if (null == service) {
            logger.error("Knative {} service not found on the {} namespace.", (Object)knativeServiceUri.getResourceName(), (Object)namespace);
            return Optional.empty();
        }
        logger.debug("Found Knative endpoint at {}", (Object)service.getStatus().getUrl());
        return Optional.of(URI.create(service.getStatus().getUrl()));
    }

    private void logConnection(KnativeClient client, String resourceName) {
        logger.info("Connected to Knative, current namespace is {}. Resource name for discovery is {}", (Object)client.getNamespace(), (Object)resourceName);
    }
}

