/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.fabric8.k8s.service.catalog;

import io.fabric8.kubernetes.client.KubernetesClient;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.net.URI;
import java.util.Optional;
import java.util.function.Supplier;
import org.kie.kogito.addons.quarkus.fabric8.k8s.service.catalog.AbstractResourceDiscovery;
import org.kie.kogito.addons.quarkus.fabric8.k8s.service.catalog.DeploymentUtils;
import org.kie.kogito.addons.quarkus.fabric8.k8s.service.catalog.IngressUtils;
import org.kie.kogito.addons.quarkus.fabric8.k8s.service.catalog.KnativeServiceDiscovery;
import org.kie.kogito.addons.quarkus.fabric8.k8s.service.catalog.KnativeServiceUri;
import org.kie.kogito.addons.quarkus.fabric8.k8s.service.catalog.KubernetesResourceUri;
import org.kie.kogito.addons.quarkus.fabric8.k8s.service.catalog.PodUtils;
import org.kie.kogito.addons.quarkus.fabric8.k8s.service.catalog.ServiceUtils;
import org.kie.kogito.addons.quarkus.fabric8.k8s.service.catalog.StatefulSetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
class KubernetesResourceDiscovery
extends AbstractResourceDiscovery {
    private static final Logger logger = LoggerFactory.getLogger((String)KubernetesResourceDiscovery.class.getName());
    private final KubernetesClient kubernetesClient;
    private final KnativeServiceDiscovery knativeServiceDiscovery;

    @Inject
    KubernetesResourceDiscovery(KubernetesClient kubernetesClient, KnativeServiceDiscovery knativeServiceDiscovery) {
        this.kubernetesClient = kubernetesClient;
        this.knativeServiceDiscovery = knativeServiceDiscovery;
    }

    Optional<URI> query(KubernetesResourceUri resourceUri) {
        this.logConnection(this.kubernetesClient, resourceUri.getResourceName());
        resourceUri = this.resolveNamespace(resourceUri, () -> ((KubernetesClient)this.kubernetesClient).getNamespace());
        switch (resourceUri.getGvk()) {
            case SERVICE: {
                return ServiceUtils.queryServiceByName(this.kubernetesClient, resourceUri);
            }
            case KNATIVE_SERVICE: {
                return this.knativeServiceDiscovery.query(new KnativeServiceUri(resourceUri.getNamespace(), resourceUri.getResourceName()));
            }
            case POD: {
                return PodUtils.queryPodByName(this.kubernetesClient, resourceUri);
            }
            case DEPLOYMENT: {
                return DeploymentUtils.queryDeploymentByName(this.kubernetesClient, resourceUri);
            }
            case STATEFUL_SET: {
                return StatefulSetUtils.queryStatefulSetByName(this.kubernetesClient, resourceUri);
            }
            case INGRESS: {
                return IngressUtils.queryIngressByName(this.kubernetesClient, resourceUri);
            }
        }
        logger.debug("Resource kind {} is not supported yet.", (Object)resourceUri.getGvk().getValue());
        return Optional.empty();
    }

    private KubernetesResourceUri resolveNamespace(KubernetesResourceUri uri, Supplier<String> defaultNamespaceSupplier) {
        if (uri.getNamespace() == null) {
            String defaultNamespace = defaultNamespaceSupplier.get();
            this.logDefaultNamespace(defaultNamespace);
            uri = uri.copyBuilder().withNamespace(defaultNamespace).build();
        }
        return uri;
    }
}

