/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.fabric8.k8s.service.catalog;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.kie.kogito.addons.quarkus.fabric8.k8s.service.catalog.GVK;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class KubernetesResourceUri {
    private static final Logger logger = LoggerFactory.getLogger((String)KubernetesResourceUri.class.getName());
    private final GVK gvk;
    private final String namespace;
    private final String resourceName;
    private final String customPortName;
    private final Map<String, String> customLabel;

    private KubernetesResourceUri(Builder builder) {
        if (builder.resourceName == null || builder.resourceName.isBlank()) {
            throw new IllegalArgumentException("resource name can't be empty");
        }
        this.gvk = builder.gvk;
        this.namespace = builder.namespace;
        this.resourceName = builder.resourceName;
        this.customPortName = builder.customPortName;
        this.customLabel = builder.customLabel != null ? Collections.unmodifiableMap(builder.customLabel) : Map.of();
    }

    GVK getGvk() {
        return this.gvk;
    }

    String getCustomPortName() {
        return this.customPortName;
    }

    Map<String, String> getCustomLabel() {
        return this.customLabel;
    }

    String getResourceName() {
        return this.resourceName;
    }

    String getNamespace() {
        return this.namespace;
    }

    public String toString() {
        return "KubernetesResourceUri{gvk=" + this.gvk + ", namespace='" + this.namespace + "', resourceName='" + this.resourceName + "', customPortName='" + this.customPortName + "', customLabel=" + this.customLabel + "} " + super.toString();
    }

    static KubernetesResourceUri parse(String rawUri) {
        KubernetesResourceUri kubernetesResourceUri = Builder.parse(rawUri).build();
        logger.debug("KubernetesResourceUri successfully parsed: {}", (Object)kubernetesResourceUri);
        return kubernetesResourceUri;
    }

    Builder copyBuilder() {
        return new Builder().withCustomLabel(this.customLabel).withGvk(this.gvk).withNamespace(this.namespace).withCustomPortName(this.customPortName).withResourceName(this.resourceName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KubernetesResourceUri that = (KubernetesResourceUri)o;
        return this.gvk == that.gvk && Objects.equals(this.namespace, that.namespace) && Objects.equals(this.resourceName, that.resourceName) && Objects.equals(this.customPortName, that.customPortName) && Objects.equals(this.customLabel, that.customLabel);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.gvk, this.namespace, this.resourceName, this.customPortName, this.customLabel});
    }

    static class Builder {
        private GVK gvk;
        private String namespace;
        private String resourceName;
        private String customPortName;
        private Map<String, String> customLabel;

        private Builder() {
        }

        static Builder parse(String rawUri) {
            Builder builder = new Builder();
            String[] values = rawUri.split("/");
            switch (values.length) {
                case 2: {
                    builder.withGvk(GVK.from(values[0]));
                    builder.withResourceName(values[1]);
                    break;
                }
                case 3: {
                    builder.withGvk(GVK.from(values[0]));
                    builder.withNamespace(values[1]);
                    builder.withResourceName(values[2]);
                    break;
                }
                default: {
                    logger.error("rawUri {} is not valid", (Object)rawUri);
                }
            }
            if (rawUri.contains("?")) {
                Builder.setAttributes(rawUri, builder);
            }
            return builder;
        }

        static void setAttributes(String attrs, Builder builder) {
            block8: for (String str : attrs.split("\\?")[1].split("&")) {
                int indexOf = str.indexOf("=");
                String param = str.substring(0, indexOf);
                String value = str.substring(indexOf + 1);
                switch (param) {
                    case "port-name": {
                        builder.withCustomPortName(value);
                        continue block8;
                    }
                    case "labels": {
                        builder.withCustomLabel(Arrays.stream(value.split(";")).map(str1 -> str1.split("=")).collect(Collectors.toMap(lblName -> lblName[0], lblValue -> lblValue[1])));
                        continue block8;
                    }
                    default: {
                        logger.warn("The given parameters {} are not supported", (Object)param);
                    }
                }
            }
        }

        Builder withGvk(GVK gvk) {
            this.gvk = gvk;
            return this;
        }

        Builder withNamespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        Builder withResourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        Builder withCustomPortName(String customPortName) {
            this.customPortName = customPortName;
            return this;
        }

        Builder withCustomLabel(Map<String, String> customLabel) {
            this.customLabel = customLabel;
            return this;
        }

        KubernetesResourceUri build() {
            return new KubernetesResourceUri(this);
        }
    }
}

