/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.fabric8.k8s.service.catalog;

import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.DeployableScalableResource;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.Optional;
import java.util.function.Supplier;
import org.kie.kogito.addons.quarkus.fabric8.k8s.service.catalog.AbstractResourceDiscovery;
import org.kie.kogito.addons.quarkus.fabric8.k8s.service.catalog.KubernetesResourceDiscovery;
import org.kie.kogito.addons.quarkus.fabric8.k8s.service.catalog.KubernetesResourceUri;
import org.kie.kogito.addons.quarkus.fabric8.k8s.service.catalog.PodUtils;
import org.kie.kogito.addons.quarkus.fabric8.k8s.service.catalog.ServiceUtils;
import org.kie.kogito.addons.quarkus.fabric8.k8s.service.catalog.URIUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
class OpenShiftResourceDiscovery
extends AbstractResourceDiscovery {
    private static final Logger logger = LoggerFactory.getLogger((String)MethodHandles.lookup().lookupClass().getName());
    private final OpenShiftClient openShiftClient;
    private final KubernetesResourceDiscovery kubernetesResourceDiscovery;

    @Inject
    OpenShiftResourceDiscovery(OpenShiftClient openShiftClient, KubernetesResourceDiscovery kubernetesResourceDiscovery) {
        this.openShiftClient = openShiftClient;
        this.kubernetesResourceDiscovery = kubernetesResourceDiscovery;
    }

    Optional<URI> query(KubernetesResourceUri resourceUri) {
        resourceUri = this.resolveNamespace(resourceUri, () -> ((OpenShiftClient)this.openShiftClient).getNamespace());
        switch (resourceUri.getGvk()) {
            case DEPLOYMENT_CONFIG: {
                return this.queryDeploymentConfigByName(resourceUri);
            }
            case ROUTE: {
                return this.queryRouteByName(resourceUri);
            }
        }
        return this.kubernetesResourceDiscovery.query(resourceUri);
    }

    private KubernetesResourceUri resolveNamespace(KubernetesResourceUri uri, Supplier<String> defaultNamespaceSupplier) {
        if (uri.getNamespace() == null) {
            String defaultNamespace = defaultNamespaceSupplier.get();
            this.logDefaultNamespace(defaultNamespace);
            uri = uri.copyBuilder().withNamespace(defaultNamespace).build();
        }
        return uri;
    }

    private Optional<URI> queryDeploymentConfigByName(KubernetesResourceUri kubeURI) {
        this.logConnection((KubernetesClient)this.openShiftClient, kubeURI.getResourceName());
        DeploymentConfig deploymentConfig = (DeploymentConfig)((DeployableScalableResource)((NonNamespaceOperation)this.openShiftClient.deploymentConfigs().inNamespace(kubeURI.getNamespace())).withName(kubeURI.getResourceName())).get();
        if (null == deploymentConfig) {
            logger.error("Openshift DeploymentConfig {} not found on the {} namespace.", (Object)kubeURI.getResourceName(), (Object)kubeURI.getNamespace());
            return Optional.empty();
        }
        logger.debug("Service for DeploymentConfig {} found, returning.", (Object)kubeURI.getResourceName());
        return ServiceUtils.queryServiceByLabelOrSelector((KubernetesClient)this.openShiftClient, deploymentConfig.getMetadata().getLabels(), deploymentConfig.getSpec().getSelector(), kubeURI).or(() -> {
            if (deploymentConfig.getStatus().getReplicas() == 1) {
                logger.debug("No service found for selector label {}, 1 replica found, trying to return podIP.", (Object)deploymentConfig.getSpec().getSelector());
                return ((ReplicationControllerList)((FilterWatchListDeletable)((NonNamespaceOperation)this.openShiftClient.replicationControllers().inNamespace(kubeURI.getNamespace())).withLabels(deploymentConfig.getSpec().getTemplate().getMetadata().getLabels())).list()).getItems().stream().filter(rss -> rss.hasOwnerReferenceFor(deploymentConfig.getMetadata().getUid())).findFirst().flatMap(foundRc -> PodUtils.queryPodByOwnerReference((KubernetesClient)this.openShiftClient, foundRc.getMetadata().getUid(), kubeURI.getNamespace(), kubeURI)).or(Optional::empty);
            }
            if (deploymentConfig.getStatus().getReplicas() > 1) {
                logger.error("DeploymentConfig has {} replicas but not service was found, KubeURI {} will not be translated", (Object)deploymentConfig.getSpec().getReplicas(), (Object)kubeURI);
            }
            return Optional.empty();
        });
    }

    private Optional<URI> queryRouteByName(KubernetesResourceUri kubeURI) {
        this.logConnection((KubernetesClient)this.openShiftClient, kubeURI.getResourceName());
        Route route = (Route)((Resource)((NonNamespaceOperation)this.openShiftClient.routes().inNamespace(kubeURI.getNamespace())).withName(kubeURI.getResourceName())).get();
        if (route == null) {
            logger.error("Route {} not found on the {} namespace.", (Object)kubeURI.getResourceName(), (Object)kubeURI.getNamespace());
            return Optional.empty();
        }
        String scheme = route.getSpec().getTls() != null ? "https" : "http";
        int port = scheme.equals("https") ? 443 : 80;
        return URIUtils.builder(scheme, port, route.getSpec().getHost());
    }
}

