/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.fabric8.k8s.service.catalog;

import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import org.kie.kogito.addons.quarkus.fabric8.k8s.service.catalog.KubernetesResourceUri;
import org.kie.kogito.addons.quarkus.fabric8.k8s.service.catalog.PortUtils;
import org.kie.kogito.addons.quarkus.fabric8.k8s.service.catalog.URIUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ServiceUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)MethodHandles.lookup().lookupClass().getName());

    private ServiceUtils() {
    }

    static Optional<URI> queryServiceByName(KubernetesClient client, KubernetesResourceUri kubeURI) {
        Service service = (Service)((ServiceResource)((NonNamespaceOperation)client.services().inNamespace(kubeURI.getNamespace())).withName(kubeURI.getResourceName())).get();
        if (service == null) {
            logger.error("Service {} not found on the {} namespace.", (Object)kubeURI.getResourceName(), (Object)kubeURI.getNamespace());
            return Optional.empty();
        }
        return ServiceUtils.getURLFromService(service, kubeURI);
    }

    static Optional<URI> queryServiceByLabelOrSelector(KubernetesClient client, Map<String, String> labels, Map<String, String> selector, KubernetesResourceUri kubeURI) {
        if (selector != null) {
            logger.info("filtering service by label selector for resource {}", (Object)kubeURI.getResourceName());
            Optional<Service> s2 = ((ServiceList)((NonNamespaceOperation)client.services().inNamespace(kubeURI.getNamespace())).list()).getItems().stream().filter(svc -> null != svc.getSpec().getSelector()).filter(svc -> svc.getSpec().getSelector().equals(selector)).findFirst().or(() -> {
                logger.debug("not found any service by selector, trying with labels...");
                return Optional.empty();
            });
            if (s2.isPresent()) {
                return ServiceUtils.getURLFromService(s2.get(), kubeURI);
            }
        }
        logger.debug("filtering service with label {}", labels);
        ServiceList services = (ServiceList)((FilterWatchListDeletable)((NonNamespaceOperation)client.services().inNamespace(kubeURI.getNamespace())).withLabels(labels)).list();
        if (services.getItems().isEmpty()) {
            logger.warn("Resource [{}] does not have any service related with labels {}", (Object)kubeURI.getResourceName(), Arrays.asList(labels));
            return Optional.empty();
        }
        if (services.getItems().size() > 1) {
            if (kubeURI.getCustomLabel().size() > 0) {
                logger.info("Multiple services for resource [{}], filtering the service using custom labels: {}", (Object)kubeURI.getResourceName(), kubeURI.getCustomLabel());
                return services.getItems().stream().filter(svc -> ServiceUtils.isServiceLabelled(svc, kubeURI.getCustomLabel())).findFirst().flatMap(s -> ServiceUtils.getURLFromService(s, kubeURI)).or(() -> {
                    logger.warn("Not able to find any service with custom label {}, returning the first in the list.", kubeURI.getCustomLabel());
                    return ServiceUtils.getURLFromService((Service)services.getItems().get(0), kubeURI);
                });
            }
            logger.warn("Found more than one service for the resource [{}] using the label selector {}, try to be more specific. Returning the first service.", (Object)kubeURI.getResourceName(), labels);
        }
        return ServiceUtils.getURLFromService((Service)services.getItems().get(0), kubeURI);
    }

    static Optional<URI> getURLFromService(Service service, KubernetesResourceUri kubeURI) {
        switch (service.getSpec().getType()) {
            case "ExternalName": {
                logger.debug("Using external service name {}", (Object)service.getSpec().getExternalName());
                return URIUtils.builder("http", 80, service.getSpec().getExternalName());
            }
            case "ClusterIP": 
            case "NodePort": {
                ServicePort port = PortUtils.findServicePort(service.getSpec().getPorts(), kubeURI);
                String protocol = PortUtils.isServicePortSecure(port) ? "https" : "http";
                return URIUtils.builder(protocol, port.getPort(), service.getSpec().getClusterIP());
            }
            case "LoadBalancer": {
                logger.warn("{} type is not yet supported", (Object)service.getSpec().getType());
                break;
            }
            default: {
                logger.debug("{} type is not supported", (Object)service.getSpec().getType());
            }
        }
        return Optional.empty();
    }

    private static boolean isServiceLabelled(Service service, Map<String, String> labels) {
        return service.getMetadata().getLabels().entrySet().stream().anyMatch(label -> labels.containsKey(label.getKey()) && labels.containsValue(label.getValue()));
    }
}

