/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.fabric8.k8s.service.catalog;

import io.fabric8.kubernetes.api.model.apps.StatefulSet;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.Optional;
import org.kie.kogito.addons.quarkus.fabric8.k8s.service.catalog.KubernetesResourceUri;
import org.kie.kogito.addons.quarkus.fabric8.k8s.service.catalog.PodUtils;
import org.kie.kogito.addons.quarkus.fabric8.k8s.service.catalog.ServiceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StatefulSetUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)MethodHandles.lookup().lookupClass().getName());

    private StatefulSetUtils() {
    }

    static Optional<URI> queryStatefulSetByName(KubernetesClient client, KubernetesResourceUri kubeURI) {
        StatefulSet statefulSet = (StatefulSet)((RollableScalableResource)((NonNamespaceOperation)client.apps().statefulSets().inNamespace(kubeURI.getNamespace())).withName(kubeURI.getResourceName())).get();
        if (statefulSet == null) {
            logger.error("StatefulSet {} not found on the {} namespace.", (Object)kubeURI.getResourceName(), (Object)kubeURI.getNamespace());
            return Optional.empty();
        }
        return ServiceUtils.queryServiceByLabelOrSelector(client, statefulSet.getSpec().getTemplate().getMetadata().getLabels(), statefulSet.getSpec().getSelector().getMatchLabels(), kubeURI).or(() -> {
            if (statefulSet.getStatus().getReplicas() == 1) {
                logger.debug("searching for statefulSet [{}] child pod with UID [{}]", (Object)kubeURI.getResourceName(), (Object)statefulSet.getMetadata().getUid());
                return PodUtils.queryPodByOwnerReference(client, statefulSet.getMetadata().getUid(), kubeURI.getNamespace(), kubeURI);
            }
            if (statefulSet.getStatus().getReplicas() > 1) {
                logger.warn("Stateful set has {} replicas but no service was found, KubeURI {} will not be translated.", (Object)statefulSet.getSpec().getReplicas(), (Object)kubeURI);
            }
            return Optional.empty();
        });
    }
}

