/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.management.quarkus;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.vertx.core.Vertx;
import io.vertx.core.json.jackson.DatabindCodec;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.WebClientOptions;
import java.net.URI;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.kie.kogito.jobs.ProcessInstanceJobDescription;
import org.kie.kogito.jobs.ProcessJobDescription;
import org.kie.kogito.jobs.management.RestJobsService;
import org.kie.kogito.jobs.service.api.Job;
import org.kie.kogito.jobs.service.api.serlialization.SerializationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class VertxJobsService
extends RestJobsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(VertxJobsService.class);
    private Vertx vertx;
    private Instance<WebClient> providedWebClient;
    private WebClient client;

    @Inject
    public VertxJobsService(@ConfigProperty(name="kogito.jobs-service.url") String jobServiceUrl, @ConfigProperty(name="kogito.service.url") String callbackEndpoint, Vertx vertx, Instance<WebClient> providedWebClient, ObjectMapper objectMapper) {
        super(jobServiceUrl, callbackEndpoint, objectMapper);
        this.vertx = vertx;
        this.providedWebClient = providedWebClient;
    }

    VertxJobsService() {
        this(null, null, null, null, null);
    }

    @PostConstruct
    void initialize() {
        this.configureMapper(DatabindCodec.mapper());
        this.configureMapper(DatabindCodec.prettyMapper());
        if (this.providedWebClient.isResolvable()) {
            this.client = (WebClient)this.providedWebClient.get();
            LOGGER.debug("Using provided web client instance");
        } else {
            URI jobServiceURL = this.getJobsServiceUri();
            this.client = WebClient.create((Vertx)this.vertx, (WebClientOptions)new WebClientOptions().setDefaultHost(jobServiceURL.getHost()).setDefaultPort(jobServiceURL.getPort()));
            LOGGER.debug("Creating new instance of web client for host {} and port {}", (Object)jobServiceURL.getHost(), (Object)jobServiceURL.getPort());
        }
    }

    public String scheduleProcessJob(ProcessJobDescription description) {
        throw new UnsupportedOperationException("Scheduling for process jobs is not yet implemented");
    }

    public String scheduleProcessInstanceJob(ProcessInstanceJobDescription description) {
        String callback = this.getCallbackEndpoint(description);
        LOGGER.debug("Job to be scheduled {} with callback URL {}", (Object)description, (Object)callback);
        Job job = this.buildJob(description, callback);
        this.client.post("/v2/jobs").sendJson((Object)job, res -> {
            int status;
            int n = status = res.result() != null ? ((HttpResponse)res.result()).statusCode() : 0;
            if (res.succeeded() && status == 200) {
                LOGGER.debug("Creating of the job {} done with status code {} ", (Object)job, (Object)status);
            } else {
                LOGGER.error("Scheduling of job {} failed with response code {}", new Object[]{job, status, res.cause()});
            }
        });
        return job.getId();
    }

    public boolean cancelJob(String id) {
        this.client.delete("/v2/jobs/" + id).send(res -> {
            if (res.succeeded() && (((HttpResponse)res.result()).statusCode() == 200 || ((HttpResponse)res.result()).statusCode() == 404)) {
                LOGGER.debug("Canceling of the job {} done with status code {} ", (Object)id, (Object)((HttpResponse)res.result()).statusCode());
            } else {
                LOGGER.error("Canceling of job {} failed with response code {}", new Object[]{id, ((HttpResponse)res.result()).statusCode(), res.cause()});
            }
        });
        return true;
    }

    private void configureMapper(ObjectMapper mapper) {
        mapper.disable(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE);
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.registerModule((Module)new JavaTimeModule());
        SerializationUtils.registerDescriptors((ObjectMapper)mapper);
        mapper.findAndRegisterModules();
    }
}

