/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.jobs.service.embedded.deployment;

import io.quarkus.agroal.DataSource;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.ExcludedTypeBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.SystemPropertyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourcePatternsBuildItem;
import io.quarkus.deployment.pkg.steps.NativeOrNativeSourcesBuild;
import io.quarkus.reactive.datasource.ReactiveDataSource;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.kie.kogito.quarkus.addons.common.deployment.KogitoCapability;
import org.kie.kogito.quarkus.addons.common.deployment.OneOfCapabilityKogitoAddOnProcessor;

class KogitoAddonsQuarkusJobsServiceEmbeddedProcessor
extends OneOfCapabilityKogitoAddOnProcessor {
    private static final String FEATURE = "kogito-addons-quarkus-jobs-service-embedded";
    private static final String JOBS_SERVICE_URL = "kogito.jobs-service.url";
    private static final String SERVICE_URL = "kogito.service.url";
    private static final String DATA_SOURCE_NAME = "jobs_service";
    private static final String DATA_SOURCE_NAME_KEY = "datasource.name";

    KogitoAddonsQuarkusJobsServiceEmbeddedProcessor() {
        super(new KogitoCapability[]{KogitoCapability.SERVERLESS_WORKFLOW, KogitoCapability.PROCESSES});
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    void buildConfiguration(BuildProducer<SystemPropertyBuildItem> systemProperties) {
        systemProperties.produce((BuildItem)new SystemPropertyBuildItem(SERVICE_URL, "http://${quarkus.http.host}:${quarkus.http.port}"));
        systemProperties.produce((BuildItem)new SystemPropertyBuildItem(JOBS_SERVICE_URL, "${kogito.service.url}"));
        systemProperties.produce((BuildItem)new SystemPropertyBuildItem(DATA_SOURCE_NAME_KEY, DATA_SOURCE_NAME));
    }

    @BuildStep
    AnnotationsTransformerBuildItem transformDataSource(final CombinedIndexBuildItem indexBuildItem) {
        return new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.FIELD;
            }

            public void transform(AnnotationsTransformer.TransformationContext context) {
                if (context.getTarget().kind() != AnnotationTarget.Kind.FIELD) {
                    return;
                }
                DotName className = DotName.createSimple((String)context.getTarget().asField().type().name().toString());
                if (indexBuildItem.getIndex().getClassByName(className) == null) {
                    return;
                }
                if (context.getTarget().asField().type().name().equals((Object)DotName.createSimple((String)"io.vertx.mutiny.pgclient.PgPool"))) {
                    ((Transformation)context.transform().add(ReactiveDataSource.class, new AnnotationValue[]{AnnotationValue.createStringValue((String)"value", (String)KogitoAddonsQuarkusJobsServiceEmbeddedProcessor.DATA_SOURCE_NAME)})).done();
                } else if (context.getTarget().asField().type().name().equals((Object)DotName.createSimple((String)"io.agroal.api.AgroalDataSource"))) {
                    ((Transformation)context.transform().add(DataSource.class, new AnnotationValue[]{AnnotationValue.createStringValue((String)"value", (String)KogitoAddonsQuarkusJobsServiceEmbeddedProcessor.DATA_SOURCE_NAME)})).done();
                }
            }
        });
    }

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    public void inMemoryNativeResources(BuildProducer<NativeImageResourcePatternsBuildItem> resource) {
        resource.produce((BuildItem)NativeImageResourcePatternsBuildItem.builder().includeGlob("postgres-*.txz").build());
    }

    @BuildStep
    public void excludeEventPublisherJobStreams(CombinedIndexBuildItem indexBuildItem, BuildProducer<ExcludedTypeBuildItem> excludedBeans) {
        if (indexBuildItem.getIndex().getClassByName(DotName.createSimple((String)"org.kie.kogito.index.addon.DataIndexEventPublisher")) == null) {
            excludedBeans.produce((BuildItem)new ExcludedTypeBuildItem("org.kie.kogito.index.addon.DataIndexEventPublisher"));
        }
    }
}

