/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.knative.serving.customfunctions;

import io.vertx.mutiny.ext.web.client.HttpRequest;
import java.util.Map;
import org.kie.kogito.addons.quarkus.knative.serving.customfunctions.KnativeFunctionPayloadSupplier;
import org.kie.kogito.event.cloudevents.utils.CloudEventUtils;
import org.kie.kogito.internal.process.runtime.KogitoWorkItem;
import org.kogito.workitem.rest.decorators.ParamsDecorator;

public final class CloudEventKnativeParamsDecorator
implements ParamsDecorator {
    public void decorate(KogitoWorkItem workItem, Map<String, Object> parameters, HttpRequest<?> request) {
        Map<String, Object> cloudEvent = KnativeFunctionPayloadSupplier.getPayload(parameters);
        if (cloudEvent.get("id") == null) {
            String cloudEventId = CloudEventKnativeParamsDecorator.generateCloudEventId(cloudEvent.hashCode(), workItem.getProcessInstanceStringId());
            cloudEvent.put("id", cloudEventId);
            parameters.put("id", cloudEventId);
        }
        CloudEventUtils.validateCloudEvent(cloudEvent);
        request.putHeader("Content-Type", "application/cloudevents+json; charset=UTF-8");
    }

    private static String generateCloudEventId(int uniqueIdentifier, String processInstanceId) {
        return processInstanceId + "_" + uniqueIdentifier;
    }
}

