/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.knative.serving.customfunctions;

import io.vertx.mutiny.ext.web.client.WebClient;
import java.net.URI;
import java.util.Map;
import org.kie.kogito.addons.k8s.resource.catalog.KubernetesProtocol;
import org.kie.kogito.addons.k8s.resource.catalog.KubernetesServiceCatalog;
import org.kie.kogito.addons.k8s.resource.catalog.KubernetesServiceCatalogKey;
import org.kie.kogito.internal.process.runtime.KogitoWorkItem;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemManager;
import org.kie.kogito.process.workitem.WorkItemExecutionException;
import org.kogito.workitem.rest.RestWorkItemHandler;

public final class KnativeWorkItemHandler
extends RestWorkItemHandler {
    public static final String APPLICATION_CLOUDEVENTS_JSON_CHARSET_UTF_8 = "application/cloudevents+json; charset=UTF-8";
    public static final String NAME = "knative";
    public static final String ID = "id";
    public static final String PATH_PROPERTY_NAME = "knative_function_path";
    public static final String SERVICE_PROPERTY_NAME = "knative_function_service";
    public static final String PAYLOAD_FIELDS_PROPERTY_NAME = "knative_function_payload_fields";
    public static final String CLOUDEVENT_SENT_AS_PLAIN_JSON_ERROR_MESSAGE = "A Knative custom function argument cannot be a CloudEvent when the 'asCloudEvent' property are not set to 'true'";
    private final KubernetesServiceCatalog kubernetesServiceCatalog;

    public KnativeWorkItemHandler(WebClient httpClient, WebClient httpsClient, KubernetesServiceCatalog kubernetesServiceCatalog) {
        super(httpClient, httpsClient);
        this.kubernetesServiceCatalog = kubernetesServiceCatalog;
    }

    public void executeWorkItem(KogitoWorkItem workItem, KogitoWorkItemManager manager) {
        Map parameters = workItem.getParameters();
        parameters.put("Url", this.getUrl(parameters));
        super.executeWorkItem(workItem, manager);
    }

    private String getUrl(Map<String, Object> parameters) {
        return this.getServiceAddress(parameters) + parameters.remove(PATH_PROPERTY_NAME);
    }

    private String getServiceAddress(Map<String, Object> parameters) {
        String service = (String)parameters.remove(SERVICE_PROPERTY_NAME);
        return this.kubernetesServiceCatalog.getServiceAddress(new KubernetesServiceCatalogKey(KubernetesProtocol.KNATIVE, service)).map(URI::toString).orElseThrow(() -> new WorkItemExecutionException("The Knative service '" + service + "' could not be found."));
    }

    public String getName() {
        return NAME;
    }
}

