/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.k8s;

import io.fabric8.knative.client.KnativeClient;
import io.fabric8.knative.serving.v1.Service;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import org.kie.kogito.addons.quarkus.k8s.parser.KubeURI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KnativeResourceDiscovery {
    private static final Logger logger = LoggerFactory.getLogger((String)MethodHandles.lookup().lookupClass().getName());
    private KnativeClient knativeClient;

    public KnativeResourceDiscovery(KubernetesClient kubernetesClient) {
        logger.debug("Trying to adapt kubernetes client to knative");
        this.knativeClient = (KnativeClient)kubernetesClient.adapt(KnativeClient.class);
    }

    public Optional<URL> queryServiceByName(KubeURI kubeURI) {
        Service service = (Service)((Resource)((NonNamespaceOperation)this.knativeClient.services().inNamespace(kubeURI.getNamespace())).withName(kubeURI.getResourceName())).get();
        if (null == service) {
            logger.error("Knative {} service not found on the {} namespace.", (Object)kubeURI.getResourceName(), (Object)kubeURI.getNamespace());
            return Optional.empty();
        }
        logger.debug("Found Knative endpoint at {}", (Object)service.getStatus().getUrl());
        try {
            return Optional.of(new URL(service.getStatus().getUrl()));
        }
        catch (MalformedURLException e) {
            logger.error("Failed to query Knative service", (Throwable)e);
            return Optional.empty();
        }
    }
}

