/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.k8s;

import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValue;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.kie.kogito.addons.quarkus.k8s.KubeConstants;
import org.kie.kogito.addons.quarkus.k8s.KubeResourceDiscovery;
import org.kie.kogito.addons.quarkus.k8s.parser.KubeURI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubeDiscoveryConfigSourceInterceptor
implements ConfigSourceInterceptor {
    private static final Logger logger = LoggerFactory.getLogger((String)MethodHandles.lookup().lookupClass().getName());
    private transient KubernetesClient client;
    private Map<String, String> cache = new ConcurrentHashMap<String, String>();
    private KubeResourceDiscovery kResource;

    public KubeDiscoveryConfigSourceInterceptor() {
        logger.debug("Configuring k8s client...");
        this.client = new DefaultKubernetesClient();
        this.kResource = new KubeResourceDiscovery(this.client);
    }

    public ConfigValue getValue(ConfigSourceInterceptorContext context, String s) {
        ConfigValue configValue = context.proceed(s);
        try {
            String cachedValue;
            if (this.isValidURI(configValue) && (cachedValue = this.cache.computeIfAbsent(configValue.getName(), k -> this.kResource.query(new KubeURI(configValue.getValue())).orElse(null))) != null) {
                return configValue.withValue(cachedValue);
            }
        }
        catch (RuntimeException e) {
            logger.error("Service Discovery has failed", (Throwable)e);
        }
        return configValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isValidURI(ConfigValue value) {
        if (value == null) return false;
        if (value.getValue().isBlank()) return false;
        if (!KubeConstants.SUPPORTED_PROTOCOLS.stream().anyMatch(value.getValue()::startsWith)) return false;
        return true;
    }
}

