/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.k8s;

import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.DeployableScalableResource;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.Optional;
import org.kie.kogito.addons.quarkus.k8s.parser.KubeURI;
import org.kie.kogito.addons.quarkus.k8s.utils.PodUtils;
import org.kie.kogito.addons.quarkus.k8s.utils.ServiceUtils;
import org.kie.kogito.addons.quarkus.k8s.utils.URIUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenShiftResourceDiscovery {
    private static final Logger logger = LoggerFactory.getLogger((String)MethodHandles.lookup().lookupClass().getName());
    private OpenShiftClient openShiftClient;

    public OpenShiftResourceDiscovery(KubernetesClient kubernetesClient) {
        logger.debug("Trying to adapt kubernetes client to OpenShift");
        this.openShiftClient = (OpenShiftClient)kubernetesClient.adapt(OpenShiftClient.class);
    }

    public Optional<URI> queryDeploymentConfigByName(KubeURI kubeURI) {
        DeploymentConfig deploymentConfig = (DeploymentConfig)((DeployableScalableResource)((NonNamespaceOperation)this.openShiftClient.deploymentConfigs().inNamespace(kubeURI.getNamespace())).withName(kubeURI.getResourceName())).get();
        if (null == deploymentConfig) {
            logger.error("Openshift DeploymentConfig {} not found on the {} namespace.", (Object)kubeURI.getResourceName(), (Object)kubeURI.getNamespace());
            return Optional.empty();
        }
        logger.debug("Service for DeploymentConfig {} found, returning.", (Object)kubeURI.getResourceName());
        return ServiceUtils.queryServiceByLabelOrSelector((KubernetesClient)this.openShiftClient, deploymentConfig.getMetadata().getLabels(), deploymentConfig.getSpec().getSelector(), kubeURI).or(() -> {
            if (deploymentConfig.getStatus().getReplicas() == 1) {
                logger.debug("No service found for selector label {}, 1 replica found, trying to return podIP.", (Object)deploymentConfig.getSpec().getSelector());
                return ((ReplicationControllerList)((FilterWatchListDeletable)((NonNamespaceOperation)this.openShiftClient.replicationControllers().inNamespace(kubeURI.getNamespace())).withLabels(deploymentConfig.getSpec().getTemplate().getMetadata().getLabels())).list()).getItems().stream().filter(rss -> rss.hasOwnerReferenceFor(deploymentConfig.getMetadata().getUid())).findFirst().flatMap(foundRc -> PodUtils.queryPodByOwnerReference((KubernetesClient)this.openShiftClient, foundRc.getMetadata().getUid(), kubeURI.getNamespace(), kubeURI)).or(Optional::empty);
            }
            if (deploymentConfig.getStatus().getReplicas() > 1) {
                logger.error("DeploymentConfig has {} replicas but not service was found, KubeURI {} will not be translated", (Object)deploymentConfig.getSpec().getReplicas(), (Object)kubeURI.getUrl());
            }
            return Optional.empty();
        });
    }

    public Optional<URI> queryRouteByName(KubeURI kubeURI) {
        Route route = (Route)((Resource)((NonNamespaceOperation)this.openShiftClient.routes().inNamespace(kubeURI.getNamespace())).withName(kubeURI.getResourceName())).get();
        if (route == null) {
            logger.error("Route {} not found on the {} namespace.", (Object)kubeURI.getResourceName(), (Object)kubeURI.getNamespace());
            return Optional.empty();
        }
        String scheme = route.getSpec().getTls() != null ? "https" : "http";
        Integer port = scheme.equals("https") ? 443 : 80;
        return URIUtils.builder(scheme, port, route.getSpec().getHost());
    }
}

