/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.k8s.parser;

import java.util.Locale;
import java.util.Optional;
import java.util.Set;

public class GVK {
    private final Optional<String> group;
    private final String version;
    private final String kind;
    private final String apiVersion;
    private Set<String> supportedGKVs = Set.of("apps/v1/deployment", "apps.openshift.io/v1/deploymentconfig", "apps/v1/statefulset", "v1/service", "route.openshift.io/v1/route", "networking.k8s.io/v1/ingress", "v1/pod", "serving.knative.dev/v1/service");

    public GVK(String group, String version, String kind) {
        this.group = Optional.of(group.toLowerCase(Locale.ROOT));
        this.version = version.toLowerCase(Locale.ROOT);
        this.kind = kind.toLowerCase(Locale.ROOT);
        this.apiVersion = this.setApiVersion();
        this.validateGivenGVK();
    }

    public GVK(String version, String kind) {
        this.version = version.toLowerCase(Locale.ROOT);
        this.kind = kind.toLowerCase(Locale.ROOT);
        this.group = Optional.empty();
        this.apiVersion = this.setApiVersion();
        this.validateGivenGVK();
    }

    private String setApiVersion() {
        return this.group.isPresent() ? this.group.get() + "/" + this.version : this.version;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public String getVersion() {
        return this.version;
    }

    public String getGVK() {
        return this.getApiVersion() + "/" + this.kind;
    }

    public String getKind() {
        return this.kind;
    }

    private void validateGivenGVK() {
        if (!this.supportedGKVs.contains(this.getGVK())) {
            throw new IllegalArgumentException("Given GVK is not valid or supported: " + this.getGVK());
        }
    }

    public String toString() {
        return "GVK{group='" + this.group.orElse("") + "', version='" + this.version + "', kind='" + this.kind + "'}";
    }
}

