/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.k8s.utils;

import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.Optional;
import org.kie.kogito.addons.quarkus.k8s.parser.KubeURI;
import org.kie.kogito.addons.quarkus.k8s.utils.PodUtils;
import org.kie.kogito.addons.quarkus.k8s.utils.ServiceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DeploymentUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)MethodHandles.lookup().lookupClass().getName());

    private DeploymentUtils() {
    }

    public static Optional<URI> queryDeploymentByName(KubernetesClient client, KubeURI kubeURI) {
        Deployment deployment = (Deployment)((RollableScalableResource)((NonNamespaceOperation)client.apps().deployments().inNamespace(kubeURI.getNamespace())).withName(kubeURI.getResourceName())).get();
        if (deployment == null) {
            logger.error("Deployment {} not found on the {} namespace.", (Object)kubeURI.getResourceName(), (Object)kubeURI.getNamespace());
            return Optional.empty();
        }
        logger.debug("Deployment {} found, returning.", (Object)kubeURI.getResourceName());
        return ServiceUtils.queryServiceByLabelOrSelector(client, deployment.getMetadata().getLabels(), deployment.getSpec().getSelector().getMatchLabels(), kubeURI).or(() -> {
            if (deployment.getStatus().getReplicas() == 1) {
                logger.debug("No service found for selector label {}, 1 replica found, trying to return podIP.", (Object)deployment.getSpec().getSelector().getMatchLabels());
                return ((ReplicaSetList)((FilterWatchListDeletable)((NonNamespaceOperation)client.apps().replicaSets().inNamespace(kubeURI.getNamespace())).withLabels(deployment.getSpec().getTemplate().getMetadata().getLabels())).list()).getItems().stream().filter(rss -> rss.hasOwnerReferenceFor(deployment.getMetadata().getUid())).findFirst().flatMap(foundRc -> PodUtils.queryPodByOwnerReference(client, foundRc.getMetadata().getUid(), kubeURI.getNamespace(), kubeURI)).or(Optional::empty);
            }
            if (deployment.getStatus().getReplicas() > 1) {
                logger.warn("Deployment set has {} replicas but no service was found, KubeURI {} will not be translated.", (Object)deployment.getSpec().getReplicas(), (Object)kubeURI.getUrl());
            }
            return Optional.empty();
        });
    }
}

