/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.k8s.utils;

import io.fabric8.kubernetes.api.model.LoadBalancerIngress;
import io.fabric8.kubernetes.api.model.networking.v1.Ingress;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.Optional;
import org.kie.kogito.addons.quarkus.k8s.parser.KubeURI;
import org.kie.kogito.addons.quarkus.k8s.utils.URIUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IngressUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)MethodHandles.lookup().lookupClass().getName());

    private IngressUtils() {
    }

    public static Optional<URI> queryIngressByName(KubernetesClient client, KubeURI kubeURI) {
        Ingress ingress = (Ingress)((Resource)((NonNamespaceOperation)client.network().v1().ingresses().inNamespace(kubeURI.getNamespace())).withName(kubeURI.getResourceName())).get();
        if (ingress == null) {
            logger.error("Ingress {} not found on the {} namespace.", (Object)kubeURI.getResourceName(), (Object)kubeURI.getNamespace());
            return Optional.empty();
        }
        String host = ((LoadBalancerIngress)ingress.getStatus().getLoadBalancer().getIngress().get(0)).getHostname() != null ? ((LoadBalancerIngress)ingress.getStatus().getLoadBalancer().getIngress().get(0)).getHostname() : ((LoadBalancerIngress)ingress.getStatus().getLoadBalancer().getIngress().get(0)).getIp();
        String scheme = !ingress.getSpec().getTls().isEmpty() ? "https" : "http";
        Integer port = scheme.equals("https") ? 443 : 80;
        return URIUtils.builder(scheme, port, host);
    }
}

