/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.k8s.utils;

import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.ServicePort;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Optional;
import org.kie.kogito.addons.quarkus.k8s.parser.KubeURI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PortUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)MethodHandles.lookup().lookupClass().getName());

    private PortUtils() {
    }

    public static ContainerPort findContainerPort(List<ContainerPort> containerPorts, KubeURI kubeURI) {
        Optional<ContainerPort> containerPort = PortUtils.containerPortHasCustomPort(containerPorts, kubeURI).or(() -> PortUtils.containerPortHasSSLPort(containerPorts)).or(() -> PortUtils.containerPortHasDefaultNamedPort(containerPorts));
        if (containerPort.isPresent()) {
            return containerPort.get();
        }
        logger.warn("Didn't find Container ports named as {}, {} or {}, returning the first in the list [{}]. For a more precise query set the {} KubeURI query parameter", new Object[]{"http", "https", "web", containerPorts.get(0).getName(), "port-name"});
        return containerPorts.get(0);
    }

    public static ServicePort findServicePort(List<ServicePort> servicePorts, KubeURI kubeURI) {
        Optional<ServicePort> servicePort = PortUtils.servicePortHasCustomPort(servicePorts, kubeURI).or(() -> PortUtils.servicePortHasSSLPort(servicePorts)).or(() -> PortUtils.servicePortHasDefaultNamedPort(servicePorts));
        if (servicePort.isPresent()) {
            return servicePort.get();
        }
        logger.warn("Didn't find Service ports named as {}, {} or {}, returning the first in the list [{}]. For a more precise query set the {} KubeURI query parameter", new Object[]{"http", "https", "web", servicePorts.get(0).getName(), "port-name"});
        return servicePorts.get(0);
    }

    public static boolean isServicePortSecure(ServicePort servicePort) {
        return servicePort.getPort() == 443 || servicePort.getPort() == 8443;
    }

    private static boolean isServiceTargetPortPresent(ServicePort servicePort) {
        return servicePort.getTargetPort() != null && servicePort.getTargetPort().getIntVal() != null;
    }

    private static Optional<ContainerPort> containerPortHasCustomPort(List<ContainerPort> containerPorts, KubeURI kubeURI) {
        if (kubeURI.getCustomPortName() != null) {
            Optional<ContainerPort> sp = containerPorts.stream().filter(p -> p.getName() != null && p.getName().equals(kubeURI.getCustomPortName())).findFirst();
            if (sp.isPresent()) {
                logger.debug("Found custom container port named as {}, returning...", (Object)kubeURI.getCustomPortName());
                return sp;
            }
            logger.warn("Custom container port is set to {}, but no port with such name was found. Trying the next available container port", (Object)kubeURI.getCustomPortName());
        }
        return Optional.empty();
    }

    private static Optional<ServicePort> servicePortHasCustomPort(List<ServicePort> servicePorts, KubeURI kubeURI) {
        if (kubeURI.getCustomPortName() != null) {
            Optional<ServicePort> sp = servicePorts.stream().filter(p -> p.getName() != null && p.getName().equals(kubeURI.getCustomPortName())).findFirst();
            if (sp.isPresent()) {
                logger.debug("Found custom service port named as {}, returning...", (Object)kubeURI.getCustomPortName());
                return sp;
            }
            logger.warn("Custom service port is set to {}, but no port with such name was found. Trying the next available port", (Object)kubeURI.getCustomPortName());
        }
        return Optional.empty();
    }

    private static Optional<ContainerPort> containerPortHasSSLPort(List<ContainerPort> containerPorts) {
        Optional<ContainerPort> secp = containerPorts.stream().filter(p -> p.getName() != null && p.getName().equals("https")).findFirst();
        secp.ifPresent(v -> logger.debug("ContainerPort {} is secured, please make sure to properly configure the client and server certificates...", (Object)v.getName()));
        return secp;
    }

    private static Optional<ServicePort> servicePortHasSSLPort(List<ServicePort> servicePorts) {
        Optional<ServicePort> secp = servicePorts.stream().filter(p -> p.getName() != null && p.getName().equals("https")).findFirst();
        secp.ifPresent(v -> logger.debug("Port {} is secured, using ssl, please make sure to properly configure the certificates at client and server...", (Object)((ServicePort)secp.get()).getName()));
        return secp;
    }

    private static Optional<ContainerPort> containerPortHasDefaultNamedPort(List<ContainerPort> containerPorts) {
        for (ContainerPort port : containerPorts) {
            if (port.getName() != null) {
                if (!port.getName().equals("http") && !port.getName().equals("web")) continue;
                logger.debug("Found port named as {}, returning...", (Object)port.getName());
                return Optional.of(port);
            }
            if (port.getName() != null || port.getContainerPort() == null) continue;
            logger.warn("target service port name is not set but port and Int targetPort is preset, returning...");
            return Optional.of(port);
        }
        return Optional.empty();
    }

    private static Optional<ServicePort> servicePortHasDefaultNamedPort(List<ServicePort> servicePorts) {
        for (ServicePort port : servicePorts) {
            if (port.getName() != null) {
                if ((port.getName() == null || !port.getName().equals("http")) && !port.getName().equals("web")) continue;
                logger.debug("Found port named as {}, returning...", (Object)port.getName());
                return Optional.of(port);
            }
            if (port.getName() != null || !PortUtils.isServiceTargetPortPresent(port)) continue;
            logger.warn("target service port name is not set but port and Int targetPort is set, returning...");
            return Optional.of(port);
        }
        return Optional.empty();
    }
}

