/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.k8s.config;

import io.smallrye.config.ConfigValue;
import org.kie.kogito.addons.k8s.resource.catalog.KubernetesProtocol;
import org.kie.kogito.addons.quarkus.k8s.config.KubeDiscoveryConfigCache;

class ConfigValueExpander {
    private final KubeDiscoveryConfigCache kubeDiscoveryConfigCache;

    ConfigValueExpander(KubeDiscoveryConfigCache kubeDiscoveryConfigCache) {
        this.kubeDiscoveryConfigCache = kubeDiscoveryConfigCache;
    }

    ConfigValue expand(ConfigValue configValue) {
        if (configValue == null || !this.valueContainsDiscovery(configValue)) {
            return configValue;
        }
        return this.kubeDiscoveryConfigCache.get(configValue.getName(), configValue.getValue()).map(arg_0 -> ((ConfigValue)configValue).withValue(arg_0)).orElse(configValue);
    }

    private boolean valueContainsDiscovery(ConfigValue configValue) {
        for (KubernetesProtocol protocol : KubernetesProtocol.values()) {
            String value = configValue.getValue();
            if (value == null || !value.startsWith(protocol.getValue() + ":")) continue;
            return true;
        }
        return false;
    }
}

