/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.k8s.config;

import java.net.URI;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.kie.kogito.addons.quarkus.k8s.config.KubeDiscoveryConfigCacheUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KubeDiscoveryConfigCache {
    private static final Logger logger = LoggerFactory.getLogger(KubeDiscoveryConfigCache.class);
    private final Map<String, String> cache = new ConcurrentHashMap<String, String>();
    private final KubeDiscoveryConfigCacheUpdater updater;

    KubeDiscoveryConfigCache(KubeDiscoveryConfigCacheUpdater updater) {
        this.updater = updater;
    }

    Optional<String> get(String configName, String configValue) {
        try {
            String cachedValue = this.cache.computeIfAbsent(configName, k -> this.updater.update(configValue).map(URI::toString).orElse(null));
            return Optional.ofNullable(cachedValue);
        }
        catch (RuntimeException e) {
            logger.error("Service Discovery has failed on property [{}={}]", new Object[]{configName, configValue, e});
            return Optional.ofNullable(configValue);
        }
    }
}

