/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.mail;

import io.quarkus.mailer.Mail;
import io.quarkus.mailer.reactive.ReactiveMailer;
import java.util.Arrays;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.kie.kogito.mail.MailInfo;
import org.kie.kogito.services.event.UserTaskDeadlineDataEvent;
import org.kie.kogito.services.event.impl.UserTaskDeadlineEventBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class QuarkusMailSender {
    private static final Logger logger = LoggerFactory.getLogger(QuarkusMailSender.class);
    @Inject
    private ReactiveMailer mailer;

    @Incoming(value="kogito-deadline-consumer")
    public void onDeadline(UserTaskDeadlineDataEvent event) {
        MailInfo mailInfo = MailInfo.of((UserTaskDeadlineEventBody)((UserTaskDeadlineEventBody)event.getData()));
        logger.info("Sending e-mail {}", (Object)mailInfo);
        Mail message = new Mail();
        if (mailInfo.to() != null) {
            message.setTo(Arrays.asList(mailInfo.to()));
        }
        if (mailInfo.from() != null) {
            message.setFrom(mailInfo.from());
        }
        if (mailInfo.replyTo() != null) {
            message.setReplyTo(mailInfo.replyTo());
        }
        if (mailInfo.subject() != null) {
            message.setSubject(mailInfo.subject());
        }
        if (mailInfo.body() != null) {
            message.setText(mailInfo.body());
        }
        this.mailer.send(new Mail[]{message}).subscribe().with(this::handleCompleted, this::handleFailure);
    }

    private void handleCompleted(Void v) {
        logger.info("Mail sent");
    }

    private void handleFailure(Throwable e) {
        logger.error("Exception sending mail ", e);
    }
}

