/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addon.quarkus.messaging.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.kie.kogito.addon.quarkus.messaging.common.message.MessageFactory;
import org.kie.kogito.conf.ConfigBean;
import org.kie.kogito.event.EventEmitter;
import org.kie.kogito.event.EventMarshaller;
import org.kie.kogito.services.event.impl.DefaultEventMarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractQuarkusCloudEventEmitter
implements EventEmitter {
    private static final Logger logger = LoggerFactory.getLogger(AbstractQuarkusCloudEventEmitter.class);
    @Inject
    ConfigBean configBean;
    @Inject
    Instance<EventMarshaller> marshallers;
    private EventMarshaller marshaller;
    @Inject
    ObjectMapper mapper;
    private MessageFactory messageFactory;

    @PostConstruct
    void init() {
        this.messageFactory = new MessageFactory(this.configBean.useCloudEvents());
        this.marshaller = this.marshallers.isUnsatisfied() ? new DefaultEventMarshaller(this.mapper) : (EventMarshaller)this.marshallers.get();
    }

    public <T> CompletionStage<Void> emit(T e, String type, Optional<Function<T, Object>> processDecorator) {
        logger.debug("publishing event {} for type {}", e, (Object)type);
        Message<String> message = this.messageFactory.getMessageDecorator().decorate(this.marshaller.marshall(this.configBean.useCloudEvents() ? processDecorator.map(d -> d.apply(e)).orElse(e) : e));
        this.emit(message);
        return (CompletionStage)message.getAck().get();
    }

    protected abstract void emit(Message<String> var1);
}

