/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addon.quarkus.messaging.common;

import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.kie.kogito.addon.cloudevents.Subscription;
import org.kie.kogito.event.EventReceiver;
import org.kie.kogito.event.SubscriptionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractQuarkusCloudEventReceiver
implements EventReceiver {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractQuarkusCloudEventReceiver.class);
    private Collection<Subscription<Object>> consumers = new CopyOnWriteArrayList<Subscription<Object>>();

    public CompletionStage<?> produce(String message) {
        return this.produce(message, null);
    }

    public CompletionStage<?> produce(Message<String> message) {
        LOGGER.debug("Received message {}", message);
        return this.produce((String)message.getPayload(), (v, e) -> {
            LOGGER.debug("Acking message {}", message.getPayload());
            message.ack();
            if (e != null) {
                LOGGER.error("Error processing message {}", message.getPayload(), e);
            }
        });
    }

    private CompletionStage<?> produce(String message, BiConsumer<Object, Throwable> callback) {
        CompletableFuture<Object> result;
        CompletionStage<Object> future = result = CompletableFuture.completedFuture(null);
        for (Subscription<Object> subscription : this.consumers) {
            try {
                Object object = subscription.getInfo().getConverter().apply((Object)message, subscription.getInfo().getOutputClass());
                future = future.thenCompose(f -> (CompletionStage)subscription.getConsumer().apply(object));
            }
            catch (IOException e) {
                LOGGER.info("Cannot convert to {} from {}, ignoring type {}, exception message is {}", new Object[]{subscription.getInfo().getOutputClass(), message, subscription.getInfo().getType(), e.getMessage()});
            }
        }
        if (callback != null) {
            future.whenComplete(callback);
        }
        return result;
    }

    public <T> void subscribe(Function<T, CompletionStage<?>> consumer, SubscriptionInfo<String, T> info) {
        this.consumers.add((Subscription<Object>)new Subscription(consumer, info));
    }
}

