/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addon.quarkus.messaging.common.message;

import org.eclipse.microprofile.reactive.messaging.Message;
import org.kie.kogito.addon.cloudevents.message.MessagePayloadDecoratorProvider;
import org.kie.kogito.addon.quarkus.messaging.common.message.MessageDecorator;
import org.kie.kogito.addon.quarkus.messaging.common.message.MessageDecoratorFactory;

public final class MessageFactory {
    private final MessageDecorator messageDecorator;
    private final MessagePayloadDecoratorProvider payloadDecoratorProvider;

    public MessageFactory(boolean useCloudEvents) {
        this.messageDecorator = MessageDecoratorFactory.newInstance(useCloudEvents);
        this.payloadDecoratorProvider = MessagePayloadDecoratorProvider.getInstance();
    }

    public Message<String> build(String payload) {
        String decoratedPayload = this.payloadDecoratorProvider.decorate(payload);
        return this.messageDecorator.decorate(decoratedPayload);
    }

    public MessageDecorator getMessageDecorator() {
        return this.messageDecorator;
    }

    public MessagePayloadDecoratorProvider getPayloadDecoratorProvider() {
        return this.payloadDecoratorProvider;
    }
}

