/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addon.quarkus.messaging.common;

import io.vertx.core.impl.ConcurrentHashSet;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.kie.kogito.addon.quarkus.messaging.common.QuarkusEmitterController;

@ApplicationScoped
public class BackpressureKogitoEmitter
implements QuarkusEmitterController {
    private Set<String> statuses = new ConcurrentHashSet();
    private Map<String, Runnable> handlers = new HashMap<String, Runnable>();

    @Override
    public boolean resume(String channelName) {
        Runnable handler;
        boolean result = this.statuses.remove(channelName);
        if (result && (handler = this.handlers.get(channelName)) != null) {
            handler.run();
        }
        return result;
    }

    @Override
    public boolean stop(String channelName) {
        return this.statuses.add(channelName);
    }

    @Override
    public boolean isEnabled(String channelName) {
        return !this.statuses.contains(channelName);
    }

    public void registerHandler(String channelName, Runnable runnable) {
        this.handlers.put(channelName, runnable);
    }
}

