/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addon.quarkus.messaging;

import io.smallrye.reactive.messaging.ChannelRegistar;
import io.smallrye.reactive.messaging.ChannelRegistry;
import io.smallrye.reactive.messaging.extension.EmitterConfiguration;
import io.smallrye.reactive.messaging.extension.MediatorManager;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.reactive.messaging.Emitter;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.kie.kogito.addon.quarkus.messaging.common.AbstractQuarkusCloudEventEmitter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Named(value="kogito_outgoing_stream_eventEmitter")
public class QuarkusCloudEventEmitter
extends AbstractQuarkusCloudEventEmitter
implements ChannelRegistar {
    private static final String PROPERTY = "mp.messaging.outgoing.kogito_outgoing_stream.connector";
    private static final Logger logger = LoggerFactory.getLogger(QuarkusCloudEventEmitter.class);
    @Inject
    private ChannelRegistry channelRegistry;
    @Inject
    private MediatorManager mediatorManager;
    private Emitter<String> emitter;

    public void initialize() {
        if (ConfigProvider.getConfig().getOptionalValue(PROPERTY, String.class).isPresent()) {
            logger.info("Registering emitter {}", (Object)"kogito_outgoing_stream");
            this.mediatorManager.addEmitter(new EmitterConfiguration("kogito_outgoing_stream", false, null, null));
        }
    }

    protected void emit(Message<String> message) {
        if (this.emitter == null) {
            this.emitter = this.channelRegistry.getEmitter("kogito_outgoing_stream");
        }
        if (this.emitter != null) {
            this.emitter.send(message);
        } else {
            logger.warn("Cannot find emitter {}", (Object)"kogito_outgoing_stream");
        }
    }
}

