/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addon.quarkus.messaging;

import io.smallrye.reactive.messaging.ChannelRegistar;
import io.smallrye.reactive.messaging.DefaultMediatorConfiguration;
import io.smallrye.reactive.messaging.MediatorConfiguration;
import io.smallrye.reactive.messaging.Shape;
import io.smallrye.reactive.messaging.annotations.Merge;
import io.smallrye.reactive.messaging.extension.MediatorManager;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.reactive.messaging.Acknowledgment;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.kie.kogito.addon.quarkus.messaging.common.AbstractQuarkusCloudEventReceiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Named(value="kogito_incoming_stream_eventReceiver")
public class QuarkusCloudEventReceiver
extends AbstractQuarkusCloudEventReceiver
implements ChannelRegistar {
    private static final Logger logger = LoggerFactory.getLogger(QuarkusCloudEventReceiver.class);
    private static final String PROPERTY = "mp.messaging.incoming.kogito_incoming_stream.connector";
    @Inject
    private MediatorManager mediatorManager;
    @Inject
    private BeanManager beanManager;

    MediatorConfiguration mediatorConf() {
        try {
            Bean bean = this.beanManager.resolve(this.beanManager.getBeans(QuarkusCloudEventReceiver.class, new Annotation[0]));
            Method method = AbstractQuarkusCloudEventReceiver.class.getMethod("produce", Message.class);
            return new DefaultMediatorConfiguration(method, bean){

                public List<String> getIncoming() {
                    return Collections.singletonList("kogito_incoming_stream");
                }

                public Shape shape() {
                    return Shape.SUBSCRIBER;
                }

                public MediatorConfiguration.Consumption consumption() {
                    return MediatorConfiguration.Consumption.MESSAGE;
                }

                public boolean isBlocking() {
                    return false;
                }

                public Acknowledgment.Strategy getAcknowledgment() {
                    return Acknowledgment.Strategy.MANUAL;
                }

                public Merge.Mode getMerge() {
                    return Merge.Mode.MERGE;
                }
            };
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
    }

    public void initialize() {
        if (ConfigProvider.getConfig().getOptionalValue(PROPERTY, String.class).isPresent()) {
            logger.info("Registering mediator {}", (Object)"kogito_incoming_stream");
            this.mediatorManager.addAnalyzed(Collections.singletonList(this.mediatorConf()));
        }
    }
}

