/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.quarkus;

import io.smallrye.config.ConfigSourceContext;
import io.smallrye.config.ConfigSourceFactory;
import io.smallrye.config.ConfigValue;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.kie.kogito.persistence.quarkus.KogitoAddOnPersistenceJDBCConfigSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KogitoAddOnPersistenceJDBCConfigSourceFactory
implements ConfigSourceFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(KogitoAddOnPersistenceJDBCConfigSourceFactory.class);
    static final String FLYWAY_LOCATIONS = "quarkus.flyway.locations";
    private static final String DATASOURCE_DB_KIND = "quarkus.datasource.db-kind";
    private static final String LOCATION_PREFIX = "classpath:/db/";
    static final String POSTGRESQL = "postgresql";
    private static final String ORACLE = "oracle";
    private static final String ANSI = "ansi";

    public Iterable<ConfigSource> getConfigSources(ConfigSourceContext context) {
        ConfigValue flywayLocationsConfigValue = context.getValue(FLYWAY_LOCATIONS);
        return this.getConfigSourcesInternal(context.getValue(DATASOURCE_DB_KIND).getValue(), flywayLocationsConfigValue.getValue(), flywayLocationsConfigValue.getConfigSourceOrdinal());
    }

    Iterable<ConfigSource> getConfigSourcesInternal(String databaseName, String flywayLocationsValue, int flywayLocationsConfigSourceOrdinal) {
        HashMap<String, String> configuration = new HashMap<String, String>();
        if (databaseName != null) {
            if (flywayLocationsValue == null || flywayLocationsConfigSourceOrdinal == Integer.MIN_VALUE) {
                configuration.put(FLYWAY_LOCATIONS, LOCATION_PREFIX + this.getDBName(databaseName));
            } else {
                Set locations = Arrays.stream(flywayLocationsValue.split(",")).collect(Collectors.toSet());
                locations.add(LOCATION_PREFIX + this.getDBName(databaseName));
                configuration.put(FLYWAY_LOCATIONS, String.join((CharSequence)",", locations));
            }
        } else {
            LOGGER.warn("Kogito Flyway must have the property \"quarkus.datasource.db-kind\" to be set to initialize process schema.");
        }
        return List.of(new KogitoAddOnPersistenceJDBCConfigSource(configuration));
    }

    public OptionalInt getPriority() {
        return OptionalInt.of(KogitoAddOnPersistenceJDBCConfigSource.ORDINAL);
    }

    private String getDBName(String dbKind) {
        if (POSTGRESQL.equals(dbKind)) {
            return POSTGRESQL;
        }
        if (ORACLE.equals(dbKind)) {
            return ORACLE;
        }
        return ANSI;
    }
}

