/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.quarkus.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import org.kie.kogito.Application;
import org.kie.kogito.jobs.api.JobCallbackPayload;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.Processes;
import org.kie.kogito.services.jobs.impl.TriggerJobCommand;

@Path(value="/management/jobs")
public class CallbackJobsServiceResource {
    @Inject
    Instance<Processes> processes;
    @Inject
    Instance<Application> application;
    @Inject
    ObjectMapper objectMapper;

    @POST
    @Path(value="{processId}/instances/{processInstanceId}/timers/{timerId}")
    @Consumes(value={"application/json"})
    public Response triggerTimer(@PathParam(value="processId") String processId, @PathParam(value="processInstanceId") String processInstanceId, @PathParam(value="timerId") String timerId, @QueryParam(value="limit") @DefaultValue(value="0") Integer limit, String payload) {
        if (processId == null || processInstanceId == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Process id and Process instance id must be given").build();
        }
        Process process = ((Processes)this.processes.get()).processById(processId);
        if (process == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Process with id " + processId + " not found")).build();
        }
        String correlationId = null;
        if (payload != null && !payload.isBlank()) {
            try {
                JobCallbackPayload jobPayload = (JobCallbackPayload)this.objectMapper.readValue(payload, JobCallbackPayload.class);
                correlationId = jobPayload.getCorrelationId();
            }
            catch (Exception e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Invalid payload: " + payload + ". " + e.getMessage())).build();
            }
        }
        return new TriggerJobCommand(processInstanceId, correlationId, timerId, limit, process, ((Application)this.application.get()).unitOfWorkManager()).execute() ? Response.status((Response.Status)Response.Status.OK).build() : Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Process instance with id " + processInstanceId + " not found")).build();
    }
}

