/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addon.source.files.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.kie.kogito.addon.source.files.SourceFilesProviderProducer;
import org.kie.kogito.addon.source.files.SourceFilesRecorder;
import org.kie.kogito.addon.source.files.deployment.SourceFileProcessBindListenerImpl;
import org.kie.kogito.addon.source.files.deployment.SourceFileServerlessWorkflowBindListenerImpl;
import org.kie.kogito.codegen.api.SourceFileCodegenBindListener;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.internal.SupportedExtensions;
import org.kie.kogito.quarkus.addons.common.deployment.KogitoCapability;
import org.kie.kogito.quarkus.addons.common.deployment.OneOfCapabilityKogitoAddOnProcessor;
import org.kie.kogito.quarkus.common.deployment.KogitoBuildContextBuildItem;

class KogitoAddOnSourceFilesProcessor
extends OneOfCapabilityKogitoAddOnProcessor {
    private static final String FEATURE = "kogito-addon-source-files-extension";

    KogitoAddOnSourceFilesProcessor() {
        super(new KogitoCapability[]{KogitoCapability.PROCESSES, KogitoCapability.SERVERLESS_WORKFLOW});
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    AdditionalBeanBuildItem sourceFilesProviderProducer() {
        return new AdditionalBeanBuildItem(new Class[]{SourceFilesProviderProducer.class});
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void addSourceFileProcessBindListener(KogitoBuildContextBuildItem ctxBuildItem, SourceFilesRecorder sourceFilesRecorder) {
        KogitoBuildContext kogitoBuildContext = ctxBuildItem.getKogitoBuildContext();
        SourceFileProcessBindListenerImpl processListener = new SourceFileProcessBindListenerImpl(kogitoBuildContext.getAppPaths().getResourceFiles(), sourceFilesRecorder);
        SourceFileServerlessWorkflowBindListenerImpl serverlessWorkflowListener = new SourceFileServerlessWorkflowBindListenerImpl(kogitoBuildContext.getAppPaths().getResourceFiles(), sourceFilesRecorder);
        kogitoBuildContext.getSourceFileCodegenBindNotifier().ifPresent(notifier -> notifier.addListeners(new SourceFileCodegenBindListener[]{processListener, serverlessWorkflowListener}));
    }

    @BuildStep
    NativeImageResourceBuildItem nativeImageResourceBuildItem(KogitoBuildContextBuildItem ctxBuildItem) throws IOException {
        return new NativeImageResourceBuildItem(this.getSourceFiles(ctxBuildItem.getKogitoBuildContext().getAppPaths().getResourceFiles()));
    }

    private List<String> getSourceFiles(File[] resourcePaths) throws IOException {
        ArrayList<String> sourceFiles = new ArrayList<String>();
        for (File resourceFile : resourcePaths) {
            Path resourcePath = resourceFile.toPath();
            try (Stream<Path> walkedPaths = Files.walk(resourcePath, new FileVisitOption[0]);){
                walkedPaths.filter(this::isSourceFile).map(resourcePath::relativize).map(Path::toString).forEach(sourceFiles::add);
            }
        }
        return sourceFiles;
    }

    private boolean isSourceFile(Path file) {
        return SupportedExtensions.isSourceFile((Path)file);
    }
}

