/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.incubation.processes;

import java.util.StringTokenizer;
import org.kie.kogito.incubation.common.LocalId;
import org.kie.kogito.incubation.processes.AttachmentId;
import org.kie.kogito.incubation.processes.CommentId;
import org.kie.kogito.incubation.processes.LocalProcessId;
import org.kie.kogito.incubation.processes.ProcessInstanceId;
import org.kie.kogito.incubation.processes.SignalId;
import org.kie.kogito.incubation.processes.TaskId;
import org.kie.kogito.incubation.processes.TaskIds;
import org.kie.kogito.incubation.processes.TaskInstanceId;

public final class ProcessIdParser {
    public static <T extends LocalId> T parse(String id, Class<T> expected) {
        String nextToken;
        String instances;
        String processId;
        LocalProcessId localProcessId;
        String processes;
        StringTokenizer tok = new StringTokenizer(id, "/");
        if (!tok.hasMoreTokens()) {
            ProcessIdParser.throwInvalid(id, "/");
        }
        if (!(processes = tok.nextToken()).equals("processes")) {
            ProcessIdParser.throwInvalid(id, "processes");
        }
        if (!tok.hasMoreTokens()) {
            ProcessIdParser.throwInvalid(id, "a process id");
        }
        if (expected == ((Object)((Object)(localProcessId = new LocalProcessId(processId = tok.nextToken())))).getClass()) {
            return (T)((Object)localProcessId);
        }
        if (!tok.hasMoreTokens()) {
            ProcessIdParser.throwInvalid(id, expected.getName());
        }
        if (!(instances = tok.nextToken()).equals("instances")) {
            ProcessIdParser.throwInvalid(id, "instances");
        }
        if (!tok.hasMoreTokens()) {
            ProcessIdParser.throwInvalid(id, "a process instance id");
        }
        String processInstanceId = tok.nextToken();
        ProcessInstanceId instanceId = localProcessId.instances().get(processInstanceId);
        if (expected == ((Object)((Object)instanceId)).getClass()) {
            return (T)((Object)instanceId);
        }
        if (!tok.hasMoreTokens()) {
            ProcessIdParser.throwInvalid(id, expected.getName());
        }
        if ((nextToken = tok.nextToken()).equals("tasks")) {
            String attachmentsOrComments;
            TaskIds taskIds = instanceId.tasks();
            if (expected == ((Object)((Object)taskIds)).getClass()) {
                return (T)((Object)taskIds);
            }
            if (!tok.hasMoreTokens()) {
                ProcessIdParser.throwInvalid(id, expected.getName());
            }
            String task = tok.nextToken();
            TaskId taskId = instanceId.tasks().get(task);
            if (expected == ((Object)((Object)taskId)).getClass()) {
                return (T)((Object)taskId);
            }
            if (!tok.hasMoreTokens() && expected.isInstance((Object)taskId)) {
                return (T)((Object)taskId);
            }
            String taskInstances = tok.nextToken();
            if (!taskInstances.equals("instances")) {
                ProcessIdParser.throwInvalid(id, "instances");
            }
            if (!tok.hasMoreTokens()) {
                ProcessIdParser.throwInvalid(id, "a task instance id");
            }
            String taskInstance = tok.nextToken();
            TaskInstanceId taskInstanceId = taskId.instances().get(taskInstance);
            if (expected == ((Object)((Object)taskInstanceId)).getClass()) {
                return (T)((Object)taskInstanceId);
            }
            if (!tok.hasMoreTokens()) {
                ProcessIdParser.throwInvalid(id, expected.getName());
            }
            if ((attachmentsOrComments = tok.nextToken()).equals("attachments")) {
                String attachment = tok.nextToken();
                AttachmentId attachmentId = taskInstanceId.attachments().get(attachment);
                if (expected == ((Object)((Object)attachmentId)).getClass()) {
                    return (T)((Object)attachmentId);
                }
                if (expected.isInstance((Object)attachmentId)) {
                    return (T)((Object)attachmentId);
                }
                if (tok.hasMoreTokens()) {
                    ProcessIdParser.throwInvalid(id, "End of URI");
                }
            }
            if (attachmentsOrComments.equals("comments")) {
                String comment = tok.nextToken();
                CommentId commentId = taskInstanceId.comments().get(comment);
                if (expected == ((Object)((Object)commentId)).getClass()) {
                    return (T)((Object)commentId);
                }
                if (expected.isInstance((Object)commentId)) {
                    return (T)((Object)commentId);
                }
                if (tok.hasMoreTokens()) {
                    ProcessIdParser.throwInvalid(id, "End of URI");
                }
            }
            throw new IllegalArgumentException("Invalid id " + id + "expected: " + expected.getName());
        }
        if (nextToken.equals("signals")) {
            if (!tok.hasMoreTokens()) {
                ProcessIdParser.throwInvalid(id, expected.getName());
            }
            String signal = tok.nextToken();
            SignalId signalId = instanceId.signals().get(signal);
            if (expected == ((Object)((Object)signalId)).getClass()) {
                return (T)((Object)signalId);
            }
            if (tok.hasMoreTokens()) {
                ProcessIdParser.throwInvalid(id, "End of URI");
            }
            if (expected.isInstance((Object)signalId)) {
                return (T)((Object)signalId);
            }
        }
        throw new IllegalArgumentException("Invalid id " + id + "expected: " + expected.getName());
    }

    public static <T extends LocalId> T select(LocalId id, Class<T> expected) {
        return ProcessIdParser.parse(id.asLocalUri().path(), expected);
    }

    private static void throwInvalid(String id, String expected) {
        throw new IllegalArgumentException("Invalid id " + id + "; expected: " + expected);
    }
}

