/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.incubation.processes;

import org.kie.kogito.incubation.common.LocalId;
import org.kie.kogito.incubation.common.LocalUriId;
import org.kie.kogito.incubation.processes.LocalProcessId;
import org.kie.kogito.incubation.processes.SignalIds;
import org.kie.kogito.incubation.processes.TaskIds;

public class ProcessInstanceId
extends LocalUriId
implements LocalId {
    public static final String PREFIX = "instances";
    private final LocalProcessId processId;
    private final String processInstanceId;

    public ProcessInstanceId(LocalProcessId processId, String processInstanceId) {
        super(processId.asLocalUri().append(PREFIX).append(processInstanceId));
        LocalId localDecisionId = processId.toLocalId();
        if (!localDecisionId.asLocalUri().startsWith("processes")) {
            throw new IllegalArgumentException("Not a valid process path");
        }
        this.processId = processId;
        this.processInstanceId = processInstanceId;
    }

    public LocalId toLocalId() {
        return this;
    }

    public LocalProcessId processId() {
        return this.processId;
    }

    public String processInstanceId() {
        return this.processInstanceId;
    }

    public TaskIds tasks() {
        return new TaskIds(this);
    }

    public SignalIds signals() {
        return new SignalIds(this);
    }
}

