/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.incubation.processes;

import org.kie.kogito.incubation.common.LocalId;
import org.kie.kogito.incubation.processes.ProcessInstanceId;
import org.kie.kogito.incubation.processes.TaskId;

public class HumanTaskId
extends TaskId
implements LocalId {
    public static final String PREFIX = "tasks";
    private final ProcessInstanceId processInstanceId;
    private final String taskId;

    public HumanTaskId(ProcessInstanceId processInstanceId, String taskId) {
        super(processInstanceId, taskId);
        LocalId localDecisionId = processInstanceId.toLocalId();
        if (!localDecisionId.asLocalUri().startsWith("processes")) {
            throw new IllegalArgumentException("Not a valid process path");
        }
        this.processInstanceId = processInstanceId;
        this.taskId = taskId;
    }

    @Override
    public LocalId toLocalId() {
        return this;
    }

    @Override
    public ProcessInstanceId processInstanceId() {
        return this.processInstanceId;
    }

    @Override
    public String taskId() {
        return this.taskId;
    }
}

