/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.incubation.rules;

import java.util.StringTokenizer;
import org.kie.kogito.incubation.common.LocalId;
import org.kie.kogito.incubation.rules.InstanceQueryId;
import org.kie.kogito.incubation.rules.QueryId;
import org.kie.kogito.incubation.rules.RuleUnitId;
import org.kie.kogito.incubation.rules.RuleUnitInstanceId;

public class RuleUnitIdParser {
    private RuleUnitIdParser() {
    }

    public static LocalId parse(String id) {
        return RuleUnitIdParser.parse(id, LocalId.class);
    }

    public static <T extends LocalId> T parse(String id, Class<T> expected) {
        StringTokenizer tok = new StringTokenizer(id, "/");
        String prefix = tok.nextToken();
        if (!prefix.equals("rule-units")) {
            throw RuleUnitIdParser.newError(id, "rule-units");
        }
        String ruleUnit = tok.nextToken();
        RuleUnitId ruleUnitId = new RuleUnitId(ruleUnit);
        if (expected == RuleUnitId.class) {
            return (T)((Object)ruleUnitId);
        }
        if (!tok.hasMoreTokens() && expected == LocalId.class) {
            return (T)((Object)ruleUnitId);
        }
        String instanceOrQuery = tok.nextToken();
        if (instanceOrQuery.equals("queries")) {
            String query = tok.nextToken();
            QueryId queryId = ruleUnitId.queries().get(query);
            if (expected == QueryId.class) {
                return (T)((Object)queryId);
            }
            if (!tok.hasMoreTokens() && expected == LocalId.class) {
                return (T)((Object)queryId);
            }
        }
        if (instanceOrQuery.equals("instances")) {
            String instanceId = tok.nextToken();
            RuleUnitInstanceId ruleUnitInstanceId = ruleUnitId.instances().get(instanceId);
            if (expected == RuleUnitInstanceId.class) {
                return (T)((Object)ruleUnitInstanceId);
            }
            if (!tok.hasMoreTokens() && expected == LocalId.class) {
                return (T)((Object)ruleUnitInstanceId);
            }
            if (!tok.nextToken().equals("queries")) {
                throw RuleUnitIdParser.newError(id, "queries");
            }
            String query = tok.nextToken();
            InstanceQueryId queryId = ruleUnitInstanceId.queries().get(query);
            if (expected == InstanceQueryId.class) {
                return (T)((Object)queryId);
            }
            if (!tok.hasMoreTokens() && expected == LocalId.class) {
                return (T)((Object)queryId);
            }
        }
        throw RuleUnitIdParser.newError(id, "instances or queries");
    }

    public static <T extends LocalId> T select(LocalId id, Class<T> expected) {
        return RuleUnitIdParser.parse(id.asLocalUri().path(), expected);
    }

    private static IllegalArgumentException newError(String id, String expected) {
        return new IllegalArgumentException("Invalid id " + id + "; expected " + expected);
    }
}

