/*
 * Decompiled with CFR 0.152.
 */
package org.kie.api.pmml;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="ParameterInfo")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlRootElement(name="parameterInfo")
public class ParameterInfo<T> {
    @XmlAttribute(name="correlationId", required=false)
    private String correlationId;
    @XmlAttribute(name="name", required=true)
    private String name;
    private String capitalizedName;
    @XmlElement(name="type")
    private Class<T> type;
    @XmlElement(name="value", type=Object.class)
    private T value;

    public ParameterInfo() {
    }

    public ParameterInfo(String correlationId, String name, Class<T> type, T value) {
        this.correlationId = correlationId;
        this.name = name;
        this.capitalizedName = name.substring(0, 1).toUpperCase() + name.substring(1);
        this.type = type;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getCapitalizedName() {
        return this.capitalizedName;
    }

    public void setName(String name) {
        this.name = name;
        this.capitalizedName = name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public Class<T> getType() {
        return this.type;
    }

    public void setType(Class<T> type) {
        this.type = type;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
        if (this.type == null) {
            this.type = value.getClass();
        }
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.correlationId == null ? 0 : this.correlationId.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParameterInfo other = (ParameterInfo)obj;
        if (this.correlationId == null ? other.correlationId != null : !this.correlationId.equals(other.correlationId)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.value == null) {
            return other.value == null;
        }
        return this.value.equals(other.value);
    }

    public String toString() {
        return "ParameterInfo( correlationId=" + this.correlationId + ", name=" + this.name + ", type=" + (this.type != null ? this.type.getName() : "undetermined") + ", value=" + this.value + " )";
    }
}

