/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.event;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.UUID;
import org.kie.kogito.event.DataEvent;

public abstract class AbstractDataEvent<T>
implements DataEvent<T> {
    private static final String SPEC_VERSION = "0.3";
    private String specversion = "0.3";
    private String id = UUID.randomUUID().toString();
    private String source;
    private String type;
    private String time;
    private T data;
    private String kogitoProcessinstanceId;
    private String kogitoRootProcessinstanceId;
    private String kogitoProcessId;
    private String kogitoRootProcessId;
    private String kogitoAddons;

    public AbstractDataEvent(String type, String source, T body, String kogitoProcessinstanceId, String kogitoRootProcessinstanceId, String kogitoProcessId, String kogitoRootProcessId, String kogitoAddons) {
        this.source = source;
        this.type = type;
        this.time = ZonedDateTime.now().format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        this.data = body;
        this.kogitoProcessinstanceId = kogitoProcessinstanceId;
        this.kogitoRootProcessinstanceId = kogitoRootProcessinstanceId;
        this.kogitoProcessId = kogitoProcessId;
        this.kogitoRootProcessId = kogitoRootProcessId;
        this.kogitoAddons = kogitoAddons;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public String getSpecversion() {
        return this.specversion;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getTime() {
        return this.time;
    }

    @Override
    public T getData() {
        return this.data;
    }

    public String getKogitoProcessinstanceId() {
        return this.kogitoProcessinstanceId;
    }

    public String getKogitoRootProcessinstanceId() {
        return this.kogitoRootProcessinstanceId;
    }

    public String getKogitoProcessId() {
        return this.kogitoProcessId;
    }

    public String getKogitoRootProcessId() {
        return this.kogitoRootProcessId;
    }

    public String getKogitoAddons() {
        return this.kogitoAddons;
    }
}

