/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.rules;

import java.util.Iterator;
import org.kie.api.internal.utils.ServiceRegistry;
import org.kie.kogito.rules.DataProcessor;
import org.kie.kogito.rules.DataStore;
import org.kie.kogito.rules.DataStream;
import org.kie.kogito.rules.SingletonStore;

public interface DataSource<T>
extends Iterable<T> {
    @Override
    default public Iterator<T> iterator() {
        throw new UnsupportedOperationException();
    }

    public void subscribe(DataProcessor<T> var1);

    public static <T> DataStream<T> createStream() {
        return FactoryHolder.get().createStream();
    }

    public static <T> DataStore<T> createStore() {
        return FactoryHolder.get().createStore();
    }

    public static <T> SingletonStore<T> createSingleton() {
        return FactoryHolder.get().createSingleton();
    }

    public static class FactoryHolder {
        public static Factory get() {
            return LazyHolder.INSTANCE;
        }

        private static class LazyHolder {
            private static Factory INSTANCE = (Factory)ServiceRegistry.getInstance().get(Factory.class);

            private LazyHolder() {
            }
        }
    }

    public static interface Factory {
        public <T> DataStream<T> createStream();

        public <T> DataStore<T> createStore();

        public <T> SingletonStore<T> createSingleton();
    }
}

