/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs;

import java.text.MessageFormat;
import java.text.ParseException;
import org.kie.kogito.jobs.AsyncJobId;
import org.kie.kogito.jobs.JobId;
import org.kie.kogito.jobs.TimerJobId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobIdResolver {
    private static final MessageFormat format = new MessageFormat("{0}:");
    private static final Logger LOGGER = LoggerFactory.getLogger(JobIdResolver.class);

    public static JobId resolve(String value) {
        try {
            String type;
            switch (type = (String)format.parse(value)[0]) {
                case "ASYNC": {
                    return new AsyncJobId().decode(value);
                }
            }
            return new TimerJobId().decode(value);
        }
        catch (ParseException e) {
            LOGGER.error("Error parsing JobId {}", (Object)value, (Object)e);
            return null;
        }
    }
}

