/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.logger;

import org.kie.api.event.KieRuntimeEventManager;
import org.kie.api.logger.KieLoggers;
import org.kie.api.logger.KieRuntimeLogger;

public class KogitoRuntimeLoggerFactory {
    private static KieLoggers knowledgeRuntimeLoggerFactoryService;

    public static KieRuntimeLogger newFileLogger(KieRuntimeEventManager session, String fileName) {
        return KogitoRuntimeLoggerFactory.getKnowledgeRuntimeLoggerProvider().newFileLogger(session, fileName);
    }

    public static KieRuntimeLogger newThreadedFileLogger(KieRuntimeEventManager session, String fileName, int interval) {
        return KogitoRuntimeLoggerFactory.getKnowledgeRuntimeLoggerProvider().newThreadedFileLogger(session, fileName, interval);
    }

    public static KieRuntimeLogger newConsoleLogger(KieRuntimeEventManager session) {
        return KogitoRuntimeLoggerFactory.getKnowledgeRuntimeLoggerProvider().newConsoleLogger(session);
    }

    private static synchronized void setKnowledgeRuntimeLoggerProvider(KieLoggers provider) {
        knowledgeRuntimeLoggerFactoryService = provider;
    }

    private static synchronized KieLoggers getKnowledgeRuntimeLoggerProvider() {
        if (knowledgeRuntimeLoggerFactoryService == null) {
            KogitoRuntimeLoggerFactory.loadProvider();
        }
        return knowledgeRuntimeLoggerFactoryService;
    }

    private static void loadProvider() {
        try {
            Class<?> cls = Class.forName("org.jbpm.audit.KogitoKnowledgeRuntimeLoggerProviderImpl");
            KogitoRuntimeLoggerFactory.setKnowledgeRuntimeLoggerProvider((KieLoggers)cls.newInstance());
        }
        catch (Exception e) {
            throw new RuntimeException("Provider org.jbpm.audit.KogitoKnowledgeRuntimeLoggerProviderImpl could not be set.", e);
        }
    }
}

