/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.correlation;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.kie.kogito.correlation.Correlation;

public class CompositeCorrelation
implements Correlation<Set<? extends Correlation<?>>> {
    private String key;
    private Set<? extends Correlation<?>> correlations;

    public CompositeCorrelation() {
    }

    public CompositeCorrelation(Set<? extends Correlation<?>> correlations) {
        this.setValue(correlations);
        this.key = CompositeCorrelation.buildKey(this.correlations);
    }

    private static String buildKey(Set<? extends Correlation<?>> correlations) {
        return correlations.stream().map(Correlation::getKey).collect(Collectors.joining("|"));
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public Set<? extends Correlation<?>> getValue() {
        return this.correlations;
    }

    public void setValue(Set<? extends Correlation<?>> correlations) {
        this.correlations = Collections.unmodifiableSet(new TreeSet(correlations));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CompositeCorrelation)) {
            return false;
        }
        CompositeCorrelation that = (CompositeCorrelation)o;
        return Objects.equals(this.getValue(), that.getValue()) && Objects.equals(this.getKey(), that.getKey());
    }

    public int hashCode() {
        return Objects.hash(this.getValue(), this.getKey());
    }

    public String toString() {
        return new StringJoiner(", ", CompositeCorrelation.class.getSimpleName() + "[", "]").add("correlations=" + this.correlations).toString();
    }
}

