/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.internal;

import java.nio.file.Path;
import java.util.Set;

public class SupportedExtensions {
    private static final Set<String> BPMN_EXTENSIONS = Set.of(".bpmn", ".bpmn2");
    private static final Set<String> SWF_EXTENSIONS = Set.of(".sw.yml", ".sw.yaml", ".sw.json");

    public static boolean isSourceFile(Path file) {
        return SupportedExtensions.isSourceFile(file.toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isSourceFile(String file) {
        if (BPMN_EXTENSIONS.stream().anyMatch(file::endsWith)) return true;
        if (!SWF_EXTENSIONS.stream().anyMatch(file::endsWith)) return false;
        return true;
    }

    public static Set<String> getBPMNExtensions() {
        return BPMN_EXTENSIONS;
    }

    public static Set<String> getSWFExtensions() {
        return SWF_EXTENSIONS;
    }

    private SupportedExtensions() {
    }
}

