/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.process;

import java.util.Optional;
import java.util.stream.Stream;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceReadMode;

public interface ProcessInstances<T> {
    default public Optional<ProcessInstance<T>> findById(String id) {
        return this.findById(id, ProcessInstanceReadMode.MUTABLE);
    }

    public Optional<ProcessInstance<T>> findById(String var1, ProcessInstanceReadMode var2);

    default public Optional<ProcessInstance<T>> findByBusinessKey(String id) {
        return this.findByBusinessKey(id, ProcessInstanceReadMode.READ_ONLY);
    }

    default public void migrateProcessInstances(String targetProcessId, String targetProcessVersion, String ... processIds) {
        throw new UnsupportedOperationException();
    }

    default public long migrateAll(String targetProcessId, String targetProcessVersion) {
        throw new UnsupportedOperationException();
    }

    default public Optional<ProcessInstance<T>> findByBusinessKey(String id, ProcessInstanceReadMode mode) {
        return this.stream(mode).filter(pi -> id.equals(pi.businessKey())).findAny();
    }

    public Stream<ProcessInstance<T>> stream(ProcessInstanceReadMode var1);

    default public Stream<ProcessInstance<T>> stream() {
        return this.stream(ProcessInstanceReadMode.READ_ONLY);
    }
}

