/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.auth;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.kie.kogito.auth.IdentityProvider;
import org.kie.kogito.auth.IdentityProviders;
import org.kie.kogito.internal.process.workitem.KogitoWorkItem;
import org.kie.kogito.internal.process.workitem.NotAuthorizedException;
import org.kie.kogito.internal.process.workitem.Policy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityPolicy
implements Policy {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityPolicy.class);
    private IdentityProvider identity;

    public static SecurityPolicy of(String name, Collection<String> roles) {
        return new SecurityPolicy(IdentityProviders.of(name, roles));
    }

    public static SecurityPolicy of(IdentityProvider identity) {
        Objects.requireNonNull(identity);
        return new SecurityPolicy(identity);
    }

    protected SecurityPolicy(IdentityProvider identity) {
        this.identity = identity;
    }

    public String getUser() {
        return this.identity.getName();
    }

    public Collection<String> getRoles() {
        return this.identity.getRoles();
    }

    @Override
    public void enforce(KogitoWorkItem workItem) {
        if (workItem.getActualOwner() != null && workItem.getActualOwner().equals(this.getUser())) {
            return;
        }
        String actualOwner = workItem.getActualOwner();
        String actualOwners = (String)workItem.getParameter("ActorId");
        String actualRoles = (String)workItem.getParameter("GroupId");
        String excludedOwner = (String)workItem.getParameter("ExcludedOwnerId");
        if (actualOwners != null || actualRoles != null) {
            ArrayList<String> owners = actualOwners != null ? new ArrayList<String>(List.of(actualOwners.split(","))) : new ArrayList();
            ArrayList<String> excluded = excludedOwner != null ? new ArrayList<String>(List.of(excludedOwner.split(","))) : new ArrayList();
            owners.removeAll(excluded);
            List<Object> roles = actualRoles != null ? List.of(actualRoles.split(",")) : new ArrayList();
            ArrayList<String> userRoles = new ArrayList<String>(this.identity.getRoles());
            userRoles.retainAll(roles);
            LOGGER.debug("enforcing identity {} and roles {} with potential owners {} and potential groups {} and exclude groups {}", new Object[]{this.identity.getName(), this.identity.getRoles(), owners, roles, excluded});
            if (!owners.contains(this.identity.getName()) && userRoles.isEmpty()) {
                LOGGER.debug("not authorized with owner {} against identity {}", (Object)actualOwner, (Object)this.identity.getName());
                throw new NotAuthorizedException("this work item " + workItem.getStringId() + " is not allows by this owner " + actualOwners + " or " + actualRoles);
            }
            if (userRoles.isEmpty() && actualOwner != null && !this.identity.getName().equals(actualOwner)) {
                LOGGER.debug("identity {} with roles {} not authorized in {}", new Object[]{this.identity.getName(), this.identity.getRoles(), roles});
                throw new NotAuthorizedException("this work item " + workItem.getStringId() + " is not allows by this owner " + actualOwner);
            }
        }
    }

    public String toString() {
        return "SecurityPolicy [identity=" + this.identity.getName() + ", roles=" + this.identity.getRoles() + "]";
    }
}

